<?php
/**
 * Localized data
 *
 * @copyright Copyright (C) 2010-2024 Combodo SAS
 * @license    https://opensource.org/licenses/AGPL-3.0
 * 
 */
/**
 *
 */
Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:AuditCategory' => 'Categoria di Audit',
	'Class:AuditCategory+' => 'Una sezione all\'interno del controllo globale',
	'Class:AuditCategory/Attribute:name' => 'Nome della categoria',
	'Class:AuditCategory/Attribute:name+' => 'Abbreviazione per questa categoria',
	'Class:AuditCategory/Attribute:description' => 'Descrizione della categoria di Audit',
	'Class:AuditCategory/Attribute:description+' => 'Descrizione dettagliata della categoria di audit',
	'Class:AuditCategory/Attribute:definition_set' => 'Insieme di definizione',
	'Class:AuditCategory/Attribute:definition_set+' => 'Espressione OQLche definisce l\'insieme di oggetti da controllare',
	'Class:AuditCategory/Attribute:rules_list' => 'Regole di Audit',
	'Class:AuditCategory/Attribute:rules_list+' => 'Regolele di audit per queste categorie',
	'Class:AuditCategory/Attribute:ok_error_tolerance' => 'Soglia di avviso',
	'Class:AuditCategory/Attribute:ok_error_tolerance+' => 'Percentuale di oggetti non validi al di sotto della quale il risultato è un avviso (arancione)',
	'Class:AuditCategory/Attribute:warning_error_tolerance' => 'Soglia di errore',
	'Class:AuditCategory/Attribute:warning_error_tolerance+' => 'Percentuale di oggetti non validi al di sotto della quale il risultato è un errore (rosso)',
	'Class:AuditCategory/Attribute:domains_list' => 'Domini',
	'Class:AuditCategory/Attribute:domains_list+' => 'Domini che includono questa categoria',
));

//
// Class: AuditRule
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:AuditRule' => 'Regola di Audit',
	'Class:AuditRule+' => '',
	'Class:AuditRule/Attribute:name' => 'Nome della regola',
	'Class:AuditRule/Attribute:name+' => '',
	'Class:AuditRule/Attribute:description' => 'Descrizione della regola di Audit',
	'Class:AuditRule/Attribute:description+' => 'Descrizione dettagliata per questa regola di audit ',
	'Class:AuditRule/Attribute:query' => 'Query da eseguire',
	'Class:AuditRule/Attribute:query+' => 'Espressio OQL da eseguire',
	'Class:AuditRule/Attribute:valid_flag' => 'Oggetti validi?',
	'Class:AuditRule/Attribute:valid_flag+' => 'Vero se la regola ritorna oggetti validi, falso altrimenti ',
	'Class:AuditRule/Attribute:valid_flag/Value:true' => 'vero',
	'Class:AuditRule/Attribute:valid_flag/Value:true+' => 'vero',
	'Class:AuditRule/Attribute:valid_flag/Value:false' => 'falso',
	'Class:AuditRule/Attribute:valid_flag/Value:false+' => 'falso',
	'Class:AuditRule/Attribute:category_id' => 'Categoria',
	'Class:AuditRule/Attribute:category_id+' => 'Categoria per questa regola',
	'Class:AuditRule/Attribute:category_name' => 'Categoria',
	'Class:AuditRule/Attribute:category_name+' => 'Nome della categoria per questa regola',
));

//
// Class: AuditDomain
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:AuditDomain' => 'Dominio di Audit',
	'Class:AuditDomain+' => 'I domini di audit permettono di raggruppare le categorie di audit.
	Il dominio di solito corrisponde a chi è responsabile del controllo e della correzione degli errori o semplicemente interessato.',
	'Class:AuditDomain/Attribute:name' => 'Nome',
	'Class:AuditDomain/Attribute:name+' => 'È una suddivisione dell\'Audit basata su chi è responsabile della correzione degli errori o chi è semplicemente interessato.',
	'Class:AuditDomain/Attribute:description' => 'Descrizione',
	'Class:AuditDomain/Attribute:description+' => '~~',
	'Class:AuditDomain/Attribute:icon' => 'Icona',
	'Class:AuditDomain/Attribute:icon+' => '~~',
	'Class:AuditDomain/Attribute:categories_list' => 'Categorie',
	'Class:AuditDomain/Attribute:categories_list+' => 'Categorie di audit correlate. Quando si esegue l\'audit su un dominio, vengono controllate solo le categorie di audit correlate.',
));

//
// Class: lnkAuditCategoryToAuditDomain
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:lnkAuditCategoryToAuditDomain' => 'Collegamento Categoria Audit / Dominio Audit',
	'Class:lnkAuditCategoryToAuditDomain+' => '~~',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id' => 'Categoria',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id+' => 'Categoria di Audit',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name' => 'Nome categoria',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name+' => 'Nome categoria di Audit',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id' => 'Dominio',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id+' => 'Dominio di Audit',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name' => 'Nome dominio',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name+' => 'Nome dominio di Audit',
));

//
// Class: QueryOQL
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:Query' => 'Query',
	'Class:Query+' => 'Una query è un insieme di dati definito in modo dinamico',
	'Class:Query/Attribute:name' => 'Nome',
	'Class:Query/Attribute:name+' => 'Identificativo della query',
	'Class:Query/Attribute:description' => 'Descrizione',
	'Class:Query/Attribute:description+' => 'Descrizione dettagliata della query (scopo, uso, ecc.)',
	'Class:Query/Attribute:is_template' => 'Template per campi OQL',
	'Class:Query/Attribute:is_template+' => 'Utilizzabile come sorgente per OQL destinatario nelle notifiche',
	'Class:Query/Attribute:is_template/Value:yes' => 'Sì',
	'Class:Query/Attribute:is_template/Value:no' => 'No',
	'Class:Query/Attribute:export_count' => 'Contatore esportazioni',
	'Class:Query/Attribute:export_count+' => 'Contatore che riflette il numero di volte in cui questa query è stata eseguita',
	'Class:Query/Attribute:export_last_date' => 'Ultima esportazione',
	'Class:Query/Attribute:export_last_date+' => 'Data e ora dell\'ultima esecuzione dell\'esportazione',
	'Class:Query/Attribute:export_last_user_id' => 'Utente',
	'Class:Query/Attribute:export_last_user_id+' => 'L\'utente che ha eseguito l\'ultima esportazione',
	'Class:Query/Attribute:export_last_user_contact' => 'Contatto',
	'Class:Query/Attribute:export_last_user_contact+' => 'Il contatto che ha eseguito l\'ultima esportazione',
	'Query:baseinfo' => 'Informazioni generali',
	'Query:exportInfo' => 'Informazioni sull\'esportazione',
	'Class:QueryOQL/Attribute:fields' => 'Campi',
	'Class:QueryOQL/Attribute:fields+' => 'Elenco di attributi separati da virgola (o alias.attributo) per l\'esportazione',
	'Class:QueryOQL' => 'Query OQL',
	'Class:QueryOQL+' => 'Una query basata su Object Query Language',
	'Class:QueryOQL/Attribute:oql' => 'Espressione',
	'Class:QueryOQL/Attribute:oql+' => 'Espressione OQL',
));

//////////////////////////////////////////////////////////////////////
// Classes in 'addon/userrights'
//////////////////////////////////////////////////////////////////////
//

//
// Class: User
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:User' => 'Utente',
	'Class:User+' => 'Login Utente',
	'Class:User/Attribute:finalclass' => 'Tipo di account',
	'Class:User/Attribute:finalclass+' => 'Nome della classe finale',
	'Class:User/Attribute:contactid' => 'Contatto (persona)',
	'Class:User/Attribute:contactid+' => 'Dettagli personali per dati aziendali',
	'Class:User/Attribute:org_id' => 'Organizzazione',
	'Class:User/Attribute:org_id+' => 'Organizzazione della persona associata',
	'Class:User/Attribute:last_name' => 'Cognome',
	'Class:User/Attribute:last_name+' => 'Cognome del contatto corrispondente',
	'Class:User/Attribute:first_name' => 'Nome',
	'Class:User/Attribute:first_name+' => 'Nome del contatto corrispondente',
	'Class:User/Attribute:email' => 'Email',
	'Class:User/Attribute:email+' => 'Email del contatto corrispondente',
	'Class:User/Attribute:login' => 'Login',
	'Class:User/Attribute:login+' => 'Stringa di identificazione dell\'utente',
	'Class:User/Attribute:language' => 'Lingua',
	'Class:User/Attribute:language+' => 'Lingua utente',
	'Class:User/Attribute:language/Value:EN US' => 'Inglese (U.S.)',
	'Class:User/Attribute:language/Value:EN US+' => 'Inglese (U.S.)',
	'Class:User/Attribute:language/Value:FR FR' => 'Francese (Francia)',
	'Class:User/Attribute:language/Value:FR FR+' => 'Francese (Francia)',
	'Class:User/Attribute:profile_list' => 'Profili',
	'Class:User/Attribute:profile_list+' => 'Regole per la concessione dei diritti per quella persona',
	'Class:User/Attribute:allowed_org_list' => 'Organizzazioni Consentite',
	'Class:User/Attribute:allowed_org_list+' => 'L\'utente finale è autorizzato a vedere i dati appartenenti alle seguenti organizzazioni. Se non è specificata alcuna organizzazione, non ci sono restrizioni.',
	'Class:User/Attribute:status' => 'Stato',
	'Class:User/Attribute:status+' => 'Se l\'account utente è abilitato o disabilitato.',
	'Class:User/Attribute:status/Value:enabled' => 'Abilitato',
	'Class:User/Attribute:status/Value:disabled' => 'Disabilitato',
	'Class:User/Error:LoginMustBeUnique' => 'Il Login deve essere unico - "%1s" già in uso',
	'Class:User/Error:AtLeastOneProfileIsNeeded' => 'È necessario almeno un profilo assegnato all\'utente.',
	'Class:User/Error:ProfileNotAllowed' => 'Il profilo "%1$s" non può essere aggiunto poiché nega l\'accesso al back office.',
	'Class:User/Error:StatusChangeIsNotAllowed' => 'La modifica dello stato non è consentita per il proprio utente.',
	'Class:User/Error:AllowedOrgsMustContainUserOrg' => 'Le organizzazioni consentite devono includere l\'organizzazione dell\'utente.',
	'Class:User/Error:CurrentProfilesHaveInsufficientRights' => 'L\'elenco attuale dei profili non conferisce diritti di accesso sufficienti (gli utenti non sono più modificabili).',
	'Class:User/Error:PortalPowerUserHasInsufficientRights' => 'Il profilo utente con poteri del portale non concede diritti di accesso sufficienti (deve essere aggiunto un altro profilo)',
	'Class:User/Error:AtLeastOneOrganizationIsNeeded' => 'È necessario assegnare almeno un\'organizzazione a questo utente.',
	'Class:User/Error:OrganizationNotAllowed' => 'Organizzazione non consentita.',
	'Class:User/Error:UserOrganizationNotAllowed' => 'L\'account utente non appartiene alle organizzazioni consentite.',
	'Class:User/Error:PersonIsMandatory' => 'Il contatto è obbligatorio.',
	'Class:User/Warning:NoOrganizationMeansFullAccess' => 'Nessuna "Organizzazione consentita" definita per questo utente, ciò significa che ha accesso a tutte le organizzazioni',
	'Class:User/Warning:NoContactHasImpact' => 'Attenzione: non è definita alcuna Persona per questo Utente, ciò impedisce l\'accesso ai portali, le notifiche di notizie e altri effetti collaterali nel back-office',
	'Class:UserInternal' => 'Utente Interno',
	'Class:UserInternal+' => 'Utente definito all\'interno di '.ITOP_APPLICATION_SHORT,
));

//
// Class: URP_Profiles
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:URP_Profiles' => 'Profilo',
	'Class:URP_Profiles+' => '',
	'Class:URP_Profiles/Attribute:name' => 'Nome',
	'Class:URP_Profiles/Attribute:name+' => '',
	'Class:URP_Profiles/Attribute:description' => 'Descrizione',
	'Class:URP_Profiles/Attribute:description+' => 'una linea di descrizione',
	'Class:URP_Profiles/Attribute:user_list' => 'Utenti',
	'Class:URP_Profiles/Attribute:user_list+' => 'Persone che hanno questo ruuolo',
));

//
// Class: URP_Dimensions
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:URP_Dimensions' => 'dimensione',
	'Class:URP_Dimensions+' => 'dimensione dell\'applicazione (definizione di silos))',
	'Class:URP_Dimensions/Attribute:name' => 'Nome',
	'Class:URP_Dimensions/Attribute:name+' => 'etichetta',
	'Class:URP_Dimensions/Attribute:description' => 'Descrizione',
	'Class:URP_Dimensions/Attribute:description+' => 'una linea di descrizione',
	'Class:URP_Dimensions/Attribute:type' => 'Tipo',
	'Class:URP_Dimensions/Attribute:type+' => 'nome della classe o tipo di dato (proiezione dell\'unità)',
));

//
// Class: URP_UserProfile
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:URP_UserProfile' => 'Utente da Profilare',
	'Class:URP_UserProfile+' => '',
	'Class:URP_UserProfile/Name' => 'Collegamento tra %1$s e %2$s',
	'Class:URP_UserProfile/Attribute:userid' => 'Utente',
	'Class:URP_UserProfile/Attribute:userid+' => '',
	'Class:URP_UserProfile/Attribute:userlogin' => 'Login',
	'Class:URP_UserProfile/Attribute:userlogin+' => 'User\'s login',
	'Class:URP_UserProfile/Attribute:profileid' => 'Profilo',
	'Class:URP_UserProfile/Attribute:profileid+' => 'utilizzo del profilo',
	'Class:URP_UserProfile/Attribute:profile' => 'Profilo',
	'Class:URP_UserProfile/Attribute:profile+' => 'Nome del profilo',
	'Class:URP_UserProfile/Attribute:reason' => 'Motivo',
	'Class:URP_UserProfile/Attribute:reason+' => 'spiega perchè questo utente dovrebbe avere questo ruolo',
));

//
// Class: URP_UserOrg
//


Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:URP_UserOrg' => 'Organizzazione dell\'utente',
	'Class:URP_UserOrg+' => '',
	'Class:URP_UserOrg/Name' => 'Collegamento tra %1$s e %2$s',
	'Class:URP_UserOrg/Attribute:userid' => 'Utente',
	'Class:URP_UserOrg/Attribute:userid+' => 'Account Utente',
	'Class:URP_UserOrg/Attribute:userlogin' => 'Login',
	'Class:URP_UserOrg/Attribute:userlogin+' => 'Login Utente',
	'Class:URP_UserOrg/Attribute:allowed_org_id' => 'Organizzazione',
	'Class:URP_UserOrg/Attribute:allowed_org_id+' => 'Organizzazione permesse',
	'Class:URP_UserOrg/Attribute:allowed_org_name' => 'Organizzazione',
	'Class:URP_UserOrg/Attribute:allowed_org_name+' => 'Organizzazione permesse',
	'Class:URP_UserOrg/Attribute:reason' => 'Motivo',
	'Class:URP_UserOrg/Attribute:reason+' => '',
));

//
// Class: URP_ProfileProjection
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:URP_ProfileProjection' => 'profile_projection',
	'Class:URP_ProfileProjection+' => 'proiezioni di profilo',
	'Class:URP_ProfileProjection/Attribute:dimensionid' => 'Dimensione',
	'Class:URP_ProfileProjection/Attribute:dimensionid+' => 'dimensione applicazione',
	'Class:URP_ProfileProjection/Attribute:dimension' => 'Dimensione',
	'Class:URP_ProfileProjection/Attribute:dimension+' => 'dimensione applicazione',
	'Class:URP_ProfileProjection/Attribute:profileid' => 'Profilo',
	'Class:URP_ProfileProjection/Attribute:profileid+' => 'utilizzo di profilo',
	'Class:URP_ProfileProjection/Attribute:profile' => 'Profilo',
	'Class:URP_ProfileProjection/Attribute:profile+' => 'Nome del profilo',
	'Class:URP_ProfileProjection/Attribute:value' => 'Valore dell\'espressione',
	'Class:URP_ProfileProjection/Attribute:value+' => 'Espressione OQL  (uso $user) | constante|  | +codice attributo',
	'Class:URP_ProfileProjection/Attribute:attribute' => 'Attributo',
	'Class:URP_ProfileProjection/Attribute:attribute+' => 'Codice attributo bersaglio (opzionale)',
));

//
// Class: URP_ClassProjection
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:URP_ClassProjection' => 'class_projection',
	'Class:URP_ClassProjection+' => 'proiezioni di classe',
	'Class:URP_ClassProjection/Attribute:dimensionid' => 'Dimensione',
	'Class:URP_ClassProjection/Attribute:dimensionid+' => 'dimensione dell\'applicazione',
	'Class:URP_ClassProjection/Attribute:dimension' => 'Dimensione',
	'Class:URP_ClassProjection/Attribute:dimension+' => 'dimensione applicazione',
	'Class:URP_ClassProjection/Attribute:class' => 'Classe',
	'Class:URP_ClassProjection/Attribute:class+' => 'Classe bersaglio',
	'Class:URP_ClassProjection/Attribute:value' => 'Valore dell\'espressione',
	'Class:URP_ClassProjection/Attribute:value+' => 'Espressione OQL (uso $this) | constante|  | +codice attributo',
	'Class:URP_ClassProjection/Attribute:attribute' => 'Attributo',
	'Class:URP_ClassProjection/Attribute:attribute+' => 'Codice attributo bersaglio (opzionale)',
));

//
// Class: URP_ActionGrant
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:URP_ActionGrant' => 'azione_autorizzazione',
	'Class:URP_ActionGrant+' => 'permesso su classi',
	'Class:URP_ActionGrant/Attribute:profileid' => 'Profilo',
	'Class:URP_ActionGrant/Attribute:profileid+' => 'Utilizzo del profilo',
	'Class:URP_ActionGrant/Attribute:profile' => 'Profilo',
	'Class:URP_ActionGrant/Attribute:profile+' => 'Utilizzo del profilo',
	'Class:URP_ActionGrant/Attribute:class' => 'Classe',
	'Class:URP_ActionGrant/Attribute:class+' => 'Classe bersaglio',
	'Class:URP_ActionGrant/Attribute:permission' => 'Autorizzazione',
	'Class:URP_ActionGrant/Attribute:permission+' => 'permesso non permesso',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes' => 'si',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes+' => 'si',
	'Class:URP_ActionGrant/Attribute:permission/Value:no' => 'no',
	'Class:URP_ActionGrant/Attribute:permission/Value:no+' => 'no',
	'Class:URP_ActionGrant/Attribute:action' => 'Azione',
	'Class:URP_ActionGrant/Attribute:action+' => '',
));

//
// Class: URP_StimulusGrant
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:URP_StimulusGrant' => 'stimulus_autorizzazione',
	'Class:URP_StimulusGrant+' => '',
	'Class:URP_StimulusGrant/Attribute:profileid' => 'Profilo',
	'Class:URP_StimulusGrant/Attribute:profileid+' => '',
	'Class:URP_StimulusGrant/Attribute:profile' => 'Profile',
	'Class:URP_StimulusGrant/Attribute:profile+' => 'usage profile',
	'Class:URP_StimulusGrant/Attribute:class' => 'Classe',
	'Class:URP_StimulusGrant/Attribute:class+' => '',
	'Class:URP_StimulusGrant/Attribute:permission' => 'Autorizzazione',
	'Class:URP_StimulusGrant/Attribute:permission+' => '',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes' => 'si',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes+' => 'si',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no' => 'no',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no+' => 'no',
	'Class:URP_StimulusGrant/Attribute:stimulus' => 'Stimulus',
	'Class:URP_StimulusGrant/Attribute:stimulus+' => 'Codice per lo Stimolus',
));

//
// Class: URP_AttributeGrant
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:URP_AttributeGrant' => 'attributo_autorizzazione',
	'Class:URP_AttributeGrant+' => 'autorizzazioni a livello di attributi',
	'Class:URP_AttributeGrant/Attribute:actiongrantid' => 'Azione di sovvenzione',
	'Class:URP_AttributeGrant/Attribute:actiongrantid+' => 'azione di sovvenzione',
	'Class:URP_AttributeGrant/Attribute:attcode' => 'Attributo',
	'Class:URP_AttributeGrant/Attribute:attcode+' => 'codice attributo',
));

//
// Class: UserDashboard
//
Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Class:UserDashboard' => 'Dashboard Utente',
	'Class:UserDashboard+' => '~~',
	'Class:UserDashboard/Attribute:user_id' => 'Utente',
	'Class:UserDashboard/Attribute:user_id+' => '~~',
	'Class:UserDashboard/Attribute:menu_code' => 'Codice Menu',
	'Class:UserDashboard/Attribute:menu_code+' => '~~',
	'Class:UserDashboard/Attribute:contents' => 'Contenuti',
	'Class:UserDashboard/Attribute:contents+' => '~~',
));

//
// Duplicated into itop-welcome-itil ( will be removed from here...)
//
Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Menu:WelcomeMenu' => 'Benveuto',
	'Menu:WelcomeMenu+' => '',
	'Menu:WelcomeMenuPage' => 'Benvenuto',
	'Menu:WelcomeMenuPage+' => '',
	'Menu:AdminTools' => 'Strumenti di amministrazione',
	'Menu:AdminTools+' => '',
	'Menu:AdminTools?' => 'Strumenti accessibile solo agli utenti con il profilo di amministratore',
	'Menu:CSVImportMenu' => 'Importazione CSV',
	'Menu:CSVImportMenu+' => '',
	'Menu:DataModelMenu' => 'Modello dati',
	'Menu:DataModelMenu+' => '',
	'Menu:ExportMenu' => 'Esporta',
	'Menu:ExportMenu+' => '',
	'Menu:NotificationsMenu' => 'Notifiche',
	'Menu:NotificationsMenu+' => '',
	'Menu:MyShortcuts' => 'Le mie scorciatoie',
	'Menu:Notifications:Title' => 'Categorie di Audit',
	'Menu:DataAdministration' => 'Dati di amministrazione',
	'Menu:DataAdministration+' => ''
));

//
// String from the User Interface: menu, messages, buttons, etc...
//

Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'BooleanLabel:yes' => 'si',
	'BooleanLabel:no' => 'no',
	'UI:Login:Title' => ITOP_APPLICATION_SHORT.' login',
	'UI:WelcomeMenu:Title' => 'Benveuto su '.ITOP_APPLICATION_SHORT, 'UI:WelcomeMenu:AllOpenRequests' => 'Apri le richieste: %1$d',
	'UI:WelcomeMenu:MyCalls' => 'Le mie richieste',
	'UI:WelcomeMenu:OpenIncidents' => 'Apri gli incidenti: %1$d',
	'UI:WelcomeMenu:AllConfigItems' => 'Elementi di Configurazione (CI): %1$d',
	'UI:WelcomeMenu:MyIncidents' => 'Incidenti assegnati a me',
	'UI:AllOrganizations' => ' Tutte le Organizzazioni ',
	'UI:YourSearch' => 'La tua Cerca',
	'UI:LoggedAsMessage' => 'Loggato come %1$s (%2$s)',
	'UI:LoggedAsMessage+Admin' => 'Loggato come %1$s (%2$s, Amministratore)',
	'UI:Button:Logoff' => 'Disconnetti',
	'UI:Button:GlobalSearch' => 'Cerca',
	'UI:Button:Search' => ' Cerca',
	'UI:Button:Clear' => 'Cancella',
	'UI:Button:Confirm' => 'Conferma',
	'UI:Button:SearchInHierarchy' => 'Cerca nella gerarchia',
	'UI:Button:Query' => ' Domanda',
	'UI:Button:Ok' => 'Ok',
	'UI:Button:Save' => 'Salva',
	'UI:Button:SaveAnd' => 'Salva e %1$s',
	'UI:Button:Cancel' => 'Cancella',
	'UI:Button:Close' => 'Chiudi',
	'UI:Button:Apply' => 'Applica',
	'UI:Button:Send' => 'Invia',
	'UI:Button:SendAnd' => 'Invia e %1$s',
	'UI:Button:Back' => ' << Indietro',
	'UI:Button:Restart' => ' |<< Riavvia',
	'UI:Button:Next' => ' Prossimo >> ',
	'UI:Button:Finish' => ' Fine',
	'UI:Button:DoImport' => ' Esegui le Imporazioni ! ',
	'UI:Button:Done' => ' Fatto',
	'UI:Button:SimulateImport' => ' Simula l\'Importazione ',
	'UI:Button:Test' => 'Testa!',
	'UI:Button:Evaluate' => ' Valuta',
	'UI:Button:Evaluate:Title' => ' Valuta (Ctrl+Enter)',
	'UI:Button:AddObject' => ' Aggiungi... ',
	'UI:Button:BrowseObjects' => ' Sfoglia... ',
	'UI:Button:Add' => ' Aggiungi ',
	'UI:Button:AddToList' => ' << Aggiungi ',
	'UI:Button:RemoveFromList' => ' Rimuovi >> ',
	'UI:Button:FilterList' => ' Filtra... ',
	'UI:Button:Create' => ' Crea ',
	'UI:Button:Delete' => ' Cancella ',
	'UI:Button:Rename' => 'Rinomina...',
	'UI:Button:ChangePassword' => 'Cambia Password',
	'UI:Button:ResetPassword' => 'Resetta Password',
	'UI:Button:Insert' => 'Inserisci',
	'UI:Button:More' => 'Di più',
	'UI:Button:Less' => 'Di meno',
	'UI:Button:Wait' => 'Attendere mentre vengono aggiornati i campi',
	'UI:Treeview:CollapseAll' => 'Chiudi tutto',
	'UI:Treeview:ExpandAll' => 'Espandi tutto',
	'UI:UserPref:DoNotShowAgain' => 'Non mostrare di nuovo',
	'UI:InputFile:NoFileSelected' => 'Nessun file selezionato',
	'UI:InputFile:SelectFile' => 'Seleziona un file',
	'UI:SearchToggle' => 'Cerca',
	'UI:ClickToCreateNew' => 'Crea un nuovo %1$s',
	'UI:SearchFor_Class' => 'Cerca l\'oggetto %1$s',
	'UI:NoObjectToDisplay' => 'Nessun oggetto da mostrare.',
	'UI:Error:SaveFailed' => 'Impossibile salvare l\'oggetto:',
	'UI:Error:MandatoryTemplateParameter_object_id' => 'Object_id parametro è obbligatorio quando link_attr è specificato. Verificare la definizione del modello di display.',
	'UI:Error:MandatoryTemplateParameter_target_attr' => 'Target_attr parametro è obbligatorio quando link_attr è specificato. Verificare la definizione del modello di display.',
	'UI:Error:MandatoryTemplateParameter_group_by' => 'Il parametro è group_by obbligatoria. Verificare la definizione del modello di display.',
	'UI:Error:InvalidGroupByFields' => 'Elenco di campi non valido per il raggruppamento: "%1$s".',
	'UI:Error:UnsupportedStyleOfBlock' => 'Errore: Stile non supportato di blocco: "%1$s".',
	'UI:Error:IncorrectLinkDefinition_LinkedClass_Class' => 'Errata definizione di link: la classe di oggetti da gestire: %1$s non è stato trovato come chiave esterna nella classe %2$s',
	'UI:Error:Object_Class_Id_NotFound' => 'Oggetto: %1$s:%2$d non trovato.',
	'UI:Error:WizardCircularReferenceInDependencies' => 'Errore: Riferimento circolare nelle dipendenze tra i campi, controllare il modello di dati.',
	'UI:Error:UploadedFileTooBig' => 'Il file caricato è troppo grande. (dimensione massima consentita è di %1$s). Verificare di configurazione di PHP per upload_max_filesize e post_max_size.',
	'UI:Error:UploadedFileTruncated.' => 'Il file caricato è stata troncato !',
	'UI:Error:NoTmpDir' => 'La directory temporanea non è definita.',
	'UI:Error:CannotWriteToTmp_Dir' => 'Impossibile scrivere il file temporaneo sul disco. upload_tmp_dir = "%1$s".',
	'UI:Error:UploadStoppedByExtension_FileName' => 'Caricamento fermato per estensione. (Nome del file originale = "%1$s").',
	'UI:Error:UploadFailedUnknownCause_Code' => 'Il caricamento del file non riuscito, causa sconosciuta. (Codice errore = "%1$s").',
	'UI:Error:1ParametersMissing' => 'Errore: il seguente parametro deve essere specificato per questa operazione: %1$s.',
	'UI:Error:2ParametersMissing' => 'Errore: i seguenti parametri devono essere specificati per questa operazione: %1$s e %2$s.',
	'UI:Error:3ParametersMissing' => 'Errore: i seguenti parametri devono essere specificati per questa operazione: %1$s, %2$s e %3$s.',
	'UI:Error:4ParametersMissing' => 'Errore: i seguenti parametri devono essere specificati per questa operazione: %1$s, %2$s, %3$s e %4$s.',
	'UI:Error:IncorrectOQLQuery_Message' => 'Errore: errata OQL query: %1$s',
	'UI:Error:AnErrorOccuredWhileRunningTheQuery_Message' => 'Si è verificato un errore durante l\'esecuzione della query: %1$s',
	'UI:Error:ObjectAlreadyUpdated' => 'Errore: l\'oggetto è già stato aggiornato.',
	'UI:Error:ObjectCannotBeUpdated' => 'Errore: oggetto non può essere aggiornato.',
	'UI:Error:ObjectsAlreadyDeleted' => 'Errore: gli oggetti sono già stati eliminati!',
	'UI:Error:BulkDeleteNotAllowedOn_Class' => 'Non hai i permessi per eseguire una eliminazione collettiva degli oggetti della classe %1$s',
	'UI:Error:DeleteNotAllowedOn_Class' => 'Non ti è permesso di eliminare gli oggetti della classe %1$s',
	'UI:Error:ReadNotAllowedOn_Class' => 'You are not allowed to view objects of class %1$s',
	'UI:Error:BulkModifyNotAllowedOn_Class' => 'Non hai i permessi per eseguire un aggiornamento collettivo degli oggetti della classe %1$s',
	'UI:Error:ObjectAlreadyCloned' => 'Errore: l\'oggetto è già stato clonato!',
	'UI:Error:ObjectAlreadyCreated' => 'Errore: l\'oggetto è già stato creato!',
	'UI:Error:Invalid_Stimulus_On_Object_In_State' => 'Errore: stimolo non valido "%1$s" su un oggetto %2$s nello stato "%3$s".',
	'UI:Error:InvalidDashboardFile' => 'Errore: file del cruscotto non valido',
	'UI:Error:InvalidDashboard' => 'Errore: cruscotto non valido',
	'UI:Error:MaintenanceMode' => 'L\'applicazione è attualmente in manutenzione',
	'UI:Error:MaintenanceTitle' => 'Manutenzione',
	'UI:Error:InvalidToken' => 'Errore: l\'operazione richiesta è già stata eseguita (token CSRF non trovato)',
	'UI:Error:SMTP:UnknownVendor' => 'Il fornitore OAuth SMTP %1$s non esiste (email_transport_smtp.oauth.provider)',
	'UI:GroupBy:Count' => 'Conteggio',
	'UI:GroupBy:Count+' => '',
	'UI:CountOfObjects' => '%1$d oggetti corrispondenti ai criteri.',
	'UI_CountOfObjectsShort' => '%1$d oggetti.',
	'UI:NoObject_Class_ToDisplay' => 'Nessun %1$s da visualizzare',
	'UI:History:LastModified_On_By' => 'Ultima modifica %1$s da %2$s.',
	'UI:HistoryTab' => 'Storia',
	'UI:NotificationsTab' => 'Notifiche',
	'UI:History:BulkImports' => 'Storia',
	'UI:History:BulkImports+' => 'Elenco delle importazioni CSV (primo ultimo)',
	'UI:History:BulkImportDetails' => 'Modifiche derivanti dai importazione CSV eseguita su %1$s (da %2$s)',
	'UI:History:Date' => 'Data',
	'UI:History:Date+' => '',
	'UI:History:User' => 'Utente',
	'UI:History:User+' => '',
	'UI:History:Changes' => 'Modifiche',
	'UI:History:Changes+' => '',
	'UI:History:StatsCreations' => 'Creato',
	'UI:History:StatsCreations+' => '',
	'UI:History:StatsModifs' => 'Modificato',
	'UI:History:StatsModifs+' => '',
	'UI:History:StatsDeletes' => 'Cancellato',
	'UI:History:StatsDeletes+' => '',
	'UI:Loading' => 'Caricamento...',
	'UI:Menu:Actions' => 'Azioni',
	'UI:Menu:OtherActions' => 'Altre Azioni',
	'UI:Menu:Transitions' => 'Transizioni',
	'UI:Menu:OtherTransitions' => 'Altre transizioni',
	'UI:Menu:View' => 'Visualizza questo oggetto',
	'UI:Menu:New' => 'Nuovo...',
	'UI:Menu:Add' => 'Aggiungi...',
	'UI:Menu:Manage' => 'Gestisci...',
	'UI:Menu:EMail' => 'eMail',
	'UI:Menu:CSVExport' => 'Esporta CSV...',
	'UI:Menu:OpenOQL' => 'View the OQL query~~',
	'UI:Menu:Modify' => 'Modifica...',
	'UI:Menu:Delete' => 'Cancella...',
	'UI:Menu:BulkDelete' => 'Cancella...',
	'UI:Menu:BulkDelete_Class' => 'Elimina %1$s oggetti...',
	'UI:Menu:BulkDelete_Link' => 'Elimina %1$s...',
	'UI:Menu:BulkDelete_Remote' => 'Elimina %1$s...',
	'UI:UndefinedObject' => 'non definito',
	'UI:Document:OpenInNewWindow:Download' => 'Apri in una nuova finestra: %1$s, Scarica: %2$s',
	'UI:SplitDateTime-Date' => 'data',
	'UI:SplitDateTime-Time' => 'ora',
	'UI:TruncatedResults' => '%1$d oggetti visualizzati su %2$d',
	'UI:DisplayAll' => 'Mostra tutto',
	'UI:CollapseList' => 'Collassa',
	'UI:CountOfResults' => '%1$d oggetto(i)',
	'UI:ChangesLogTitle' => 'Log delle modifiche (%1$d):',
	'UI:EmptyChangesLogTitle' => 'Log delle modifiche è vuoto',
	'UI:SearchFor_Class_Objects' => 'Cerca per  %1$s Oggetti',
	'UI:OQLQueryBuilderTitle' => 'OQL Query Builder',
	'UI:OQLQueryTab' => 'OQL Query',
	'UI:SimpleSearchTab' => 'Ricerca semplice',
	'UI:Details+' => '',
	'UI:SearchValue:Any' => '* Qualsiasi *',
	'UI:SearchValue:Mixed' => '* misti *',
	'UI:SearchValue:NbSelected' => '# selezionati',
	'UI:SearchValue:CheckAll' => 'Seleziona tutti',
	'UI:SearchValue:UncheckAll' => 'Deseleziona tutti',
	'UI:SelectOne' => '-- selezionare uno --',
	'UI:Login:Welcome' => 'Benvenuti su '.ITOP_APPLICATION_SHORT.'!',
	'UI:Login:IncorrectLoginPassword' => 'Errato login/password, si prega di riprovare.',
	'UI:Login:IdentifyYourself' => 'Identifica te stesso prima di continuare',
	'UI:Login:UserNamePrompt' => 'Nome Utente',
	'UI:Login:PasswordPrompt' => 'Password',
	'UI:Login:ForgotPwd' => 'Hai dimenticato la password?',
	'UI:Login:ForgotPwdForm' => 'Password dimenticata',
	'UI:Login:ForgotPwdForm+' => ITOP_APPLICATION_SHORT.' può inviarti un\'email contenente le istruzioni da seguire per reimpostare il tuo account.',
	'UI:Login:ResetPassword' => 'Invia ora!',
	'UI:Login:ResetPwdFailed' => 'Impossibile inviare un\'email: %1$s',
	'UI:Login:SeparatorOr' => 'O',
	'UI:ResetPwd-Error-WrongLogin' => '\'%1$s\' non è un nome utente valido',
	'UI:ResetPwd-Error-NotPossible' => 'gli account esterni non consentono la reimpostazione della password.',
	'UI:ResetPwd-Error-FixedPwd' => 'l\'account non consente la reimpostazione della password.',
	'UI:ResetPwd-Error-NoContact' => 'l\'account non è associato a una persona.',
	'UI:ResetPwd-Error-NoEmailAtt' => 'l\'account non è associato a una persona con un attributo email. Per favore, contatta il tuo amministratore.',
	'UI:ResetPwd-Error-NoEmail' => 'indirizzo email mancante. Per favore, contatta il tuo amministratore.',
	'UI:ResetPwd-Error-Send' => 'problema tecnico nel trasporto dell\'email. Per favore, contatta il tuo amministratore.',
	'UI:ResetPwd-EmailSent' => 'Controlla la tua casella email e segui le istruzioni. Se non ricevi alcuna email, verifica il nome utente che hai inserito.',
	'UI:ResetPwd-EmailSubject' => 'Reimposta la password di '.ITOP_APPLICATION_SHORT, 'UI:ResetPwd-EmailBody' => '<body><p>Hai richiesto di reimpostare la password di '.ITOP_APPLICATION_SHORT.'.</p><p>Segui questo link (uso singolo) per <a href="%1$s">inserire una nuova password</a></p>.',
	'UI:ResetPwd-Title' => 'Reimposta la password',
	'UI:ResetPwd-Error-InvalidToken' => 'Spiacenti, o la password è già stata reimpostata, o hai ricevuto diverse email. Assicurati di utilizzare il link fornito nell\'ultima email ricevuta.',
	'UI:ResetPwd-Error-EnterPassword' => 'Inserisci una nuova password per l\'account \'%1$s\'.',
	'UI:ResetPwd-Ready' => 'La password è stata cambiata.',
	'UI:ResetPwd-Login' => 'Clicca qui per accedere...',
	'UI:Login:About' => ITOP_APPLICATION.' Sviluppato da Combodo',
	'UI:Login:ChangeYourPassword' => 'Cambia la tua password',
	'UI:Login:OldPasswordPrompt' => 'Vecchia password',
	'UI:Login:NewPasswordPrompt' => 'Nuova password',
	'UI:Login:RetypeNewPasswordPrompt' => 'Riscrivi la nuova password',
	'UI:Login:IncorrectOldPassword' => 'Errore: la vecchia password non è corretta',
	'UI:LogOffMenu' => 'Log off',
	'UI:LogOff:ThankYou' => 'Grazie per aver scelto '.ITOP_APPLICATION_SHORT, 'UI:LogOff:ClickHereToLoginAgain' => 'Clicca qui per effettuare il login di nuovo...',
	'UI:ChangePwdMenu' => 'Cambia Password...',
	'UI:Login:PasswordChanged' => 'Password impostata con successo!',
	'UI:Login:PasswordNotChanged' => 'Errore: La password è la stessa!',
	'UI:AccessRO-All' => ITOP_APPLICATION_SHORT.' è di sola lettura',
	'UI:AccessRO-Users' => ITOP_APPLICATION_SHORT.' è di sola lettura per gli utenti finali',
	'UI:ApplicationEnvironment' => 'Ambiente dell\'applicazione: %1$s',
	'UI:Login:RetypePwdDoesNotMatch' => 'Nuova password e la nuova password digitata nuovamente non corrispondono !',
	'UI:Button:Login' => 'Entra in '.ITOP_APPLICATION_SHORT, 'UI:Login:Error:AccessRestricted' => 'L\'accesso a '.ITOP_APPLICATION_SHORT.' è limitato. Si prega di contattare un amministratore '.ITOP_APPLICATION_SHORT.'.',
	'UI:Login:Error:AccessAdmin' => 'Accesso limitato alle persone che hanno privilegi di amministratore. Si prega di contattare un amministratore '.ITOP_APPLICATION_SHORT.'.',
	'UI:Login:Error:WrongOrganizationName' => 'Organizzazione sconosciuta',
	'UI:Login:Error:MultipleContactsHaveSameEmail' => 'Più contatti hanno la stessa e-mail',
	'UI:Login:Error:NoValidProfiles' => 'Nessun profilo valido fornito',
	'UI:CSVImport:MappingSelectOne' => '-- seleziona uno --',
	'UI:CSVImport:MappingNotApplicable' => '-- ignora questo campo --',
	'UI:CSVImport:NoData' => 'Insieme di dati vuoto ..., si prega di fornire alcuni dati!',
	'UI:Title:DataPreview' => 'Anteprima dati',
	'UI:CSVImport:ErrorOnlyOneColumn' => 'Errore: I dati contengono solo una colonna. Avete selezionato il carattere separatore appropriato?',
	'UI:CSVImport:FieldName' => 'Campo %1$d',
	'UI:CSVImport:DataLine1' => 'Dati Linea 1',
	'UI:CSVImport:DataLine2' => 'Dati Linea 2',
	'UI:CSVImport:idField' => 'id (Chiave Primaria)',
	'UI:Title:BulkImport' => ITOP_APPLICATION_SHORT.' - importazione collettiva',
	'UI:Title:BulkImport+' => '',
	'UI:Title:BulkSynchro_nbItem_ofClass_class' => 'Sincronizzazione di %1$d oggetti della classe %2$s',
	'UI:CSVImport:ClassesSelectOne' => '-- seleziona uno --',
	'UI:CSVImport:ErrorExtendedAttCode' => 'Errore interno: "%1$s" è un codice errato, perché "%2$s" NON è una chiave esterna della classe "%3$s"',
	'UI:CSVImport:ObjectsWillStayUnchanged' => '%1$d oggetto(i) rimarrà invariato.',
	'UI:CSVImport:ObjectsWillBeModified' => '%1$d oggetto(i) sarà modificato.',
	'UI:CSVImport:ObjectsWillBeAdded' => '%1$d oggetto(i) sarà aggiunto.',
	'UI:CSVImport:ObjectsWillHaveErrors' => '%1$d oggetto(i) avranno i errori.',
	'UI:CSVImport:ObjectsRemainedUnchanged' => '%1$d oggetto(i) è rimasto invariato.',
	'UI:CSVImport:ObjectsWereModified' => '%1$d oggetto(i) sono stati modificati.',
	'UI:CSVImport:ObjectsWereAdded' => '%1$d oggetto(i) sono stati aggiunti.',
	'UI:CSVImport:ObjectsHadErrors' => '%1$d oggetto(i) hanno avuto errori.',
	'UI:Title:CSVImportStep2' => 'Step 2 of 5: opzioni dati CVS',
	'UI:Title:CSVImportStep3' => 'Step 3 of 5: Mappatura dei dati',
	'UI:Title:CSVImportStep4' => 'Step 4 of 5: Importa simulazione',
	'UI:Title:CSVImportStep5' => 'Step 5 of 5: Importazione completata',
	'UI:CSVImport:LinesNotImported' => 'Linee che non possono essere caricate:',
	'UI:CSVImport:LinesNotImported+' => '',
	'UI:CSVImport:SeparatorComma+' => '',
	'UI:CSVImport:SeparatorSemicolon+' => '',
	'UI:CSVImport:SeparatorTab+' => '',
	'UI:CSVImport:SeparatorOther' => 'altri:',
	'UI:CSVImport:QualifierDoubleQuote+' => '',
	'UI:CSVImport:QualifierSimpleQuote+' => '',
	'UI:CSVImport:QualifierOther' => 'altro:',
	'UI:CSVImport:TreatFirstLineAsHeader' => 'Tratta la prima riga come intestazione (nomi di colonna)',
	'UI:CSVImport:Skip_N_LinesAtTheBeginning' => 'Salta le linee %1$s all\'inzio del file',
	'UI:CSVImport:CSVDataPreview' => 'CSV Anteprima dei dati',
	'UI:CSVImport:Column' => 'Colonna %1$s',
	'UI:CSVImport:SelectFile' => 'Selezionare il file da importare:',
	'UI:CSVImport:Tab:LoadFromFile' => 'Carica da un file',
	'UI:CSVImport:Tab:CopyPaste' => 'Copia e incolla i dati',
	'UI:CSVImport:Tab:Templates' => 'Modelli',
	'UI:CSVImport:PasteData' => 'Incolla i dati da importare:',
	'UI:CSVImport:PickClassForTemplate' => 'Scegli il modello da scaricare: ',
	'UI:CSVImport:SeparatorCharacter' => 'Separatore di carattere:',
	'UI:CSVImport:TextQualifierCharacter' => 'Testo di qualificazione carattere',
	'UI:CSVImport:CommentsAndHeader' => 'Commenti e intestazione',
	'UI:CSVImport:SelectClass' => 'Selezionare la classe da importare:',
	'UI:CSVImport:AdvancedMode' => 'Modalità avanzata',
	'UI:CSVImport:AdvancedMode+' => '',
	'UI:CSVImport:SelectAClassFirst' => 'Per configurare il mapping, selezionare prima una classe.',
	'UI:CSVImport:HeaderFields' => 'Campi',
	'UI:CSVImport:HeaderMappings' => 'Mappings',
	'UI:CSVImport:HeaderSearch' => 'Cerca?',
	'UI:CSVImport:AlertIncompleteMapping' => 'Per favore seleziona una mappatura per ogni campo.',
	'UI:CSVImport:AlertMultipleMapping' => 'Assicurati che un campo di destinazione sia mappato una sola volta.',
	'UI:CSVImport:AlertNoSearchCriteria' => 'Per favore seleziona almeno un criterio di ricerca',
	'UI:CSVImport:Encoding' => 'Codifica dei caratteri',
	'UI:CSVImport:ViewAllPossibleValues' => 'Visualizza tutti i valori possibili',
	'UI:CSVImport:ViewAllAmbiguousValues' => 'Visualizza tutti i valori ambigui',
	'UI:UniversalSearchTitle' => ITOP_APPLICATION_SHORT.' - Ricerca Universale',
	'UI:UniversalSearch:Error' => 'Errore: %1$s',
	'UI:UniversalSearch:LabelSelectTheClass' => 'Seleziona la classe per la ricerca: ',
	'UI:CSVReport-Value-Modified' => 'Modificato',
	'UI:CSVReport-Value-SetIssue' => 'valore non valido per l\'attributo',
	'UI:CSVReport-Value-ChangeIssue' => '\'%1$s\' è un valore non valido',
	'UI:CSVReport-Value-NoMatch' => 'Nessuna corrispondenza per il valore \'%1$s\'',
	'UI:CSVReport-Value-NoMatch-PossibleValues' => 'Alcuni possibili valori per \'%1$s\': %2$s',
	'UI:CSVReport-Value-NoMatch-NoObject' => 'Non ci sono oggetti \'%1$s\'',
	'UI:CSVReport-Value-NoMatch-NoObject-ForCurrentUser' => 'Non ci sono oggetti \'%1$s\' trovati con il tuo profilo attuale',
	'UI:CSVReport-Value-NoMatch-SomeObjectNotVisibleForCurrentUser' => 'Ci sono alcuni oggetti \'%1$s\' non visibili con il tuo profilo attuale',
	'UI:CSVReport-Value-Missing' => 'Valore obbligatorio mancante',
	'UI:CSVReport-Value-Ambiguous' => 'Ambiguo: trovati %1$s oggetti',
	'UI:CSVReport-Row-Unchanged' => 'non modificato',
	'UI:CSVReport-Row-Created' => 'creato',
	'UI:CSVReport-Row-Updated' => 'aggiornato %1$d colonne',
	'UI:CSVReport-Row-Disappeared' => 'scomparso, modificato %1$d colonne',
	'UI:CSVReport-Row-Issue' => 'Problema: %1$s',
	'UI:CSVReport-Value-Issue-Null' => 'Nullo non consentito',
	'UI:CSVReport-Value-Issue-NotFound' => 'Oggetto non trovato',
	'UI:CSVReport-Value-Issue-FoundMany' => 'Trovate %1$d corrispondenze',
	'UI:CSVReport-Value-Issue-Readonly' => 'L\'attributo \'%1$s\' è di sola lettura e non può essere modificato (valore corrente: %2$s, valore proposto: %3$s)',
	'UI:CSVReport-Value-Issue-Format' => 'Impossibile elaborare l\'input: %1$s',
	'UI:CSVReport-Value-Issue-NoMatch' => 'Valore inatteso per l\'attributo \'%1$s\': nessuna corrispondenza trovata, controlla la scrittura',
	'UI:CSVReport-Value-Issue-AllowedValues' => 'Valore/i consentito/i per \'%1$s\': %2$s',
	'UI:CSVReport-Value-Issue-Unknown' => 'Valore inatteso per l\'attributo \'%1$s\': %2$s',
	'UI:CSVReport-Row-Issue-Inconsistent' => 'Attributi non coerenti tra loro: %1$s',
	'UI:CSVReport-Row-Issue-Attribute' => 'Valori dell\'attributo inaspettati',
	'UI:CSVReport-Row-Issue-MissingExtKey' => 'Non è stato possibile creare, a causa della mancanza di chiavi esterne: %1$s',
	'UI:CSVReport-Row-Issue-DateFormat' => 'formato data errato',
	'UI:CSVReport-Row-Issue-ExpectedDateFormat' => 'Formato atteso: %1$s',
	'UI:CSVReport-Row-Issue-Reconciliation' => 'fallita la conciliazione',
	'UI:CSVReport-Row-Issue-Ambiguous' => 'conciliazione ambigua',
	'UI:CSVReport-Row-Issue-Internal' => 'Errore interno: %1$s, %2$s',
	'UI:CSVReport-Icon-Unchanged' => 'Invariato',
	'UI:CSVReport-Icon-Modified' => 'Modificato',
	'UI:CSVReport-Icon-Missing' => 'Mancante',
	'UI:CSVReport-Object-MissingToUpdate' => 'Oggetto mancante: sarà aggiornato',
	'UI:CSVReport-Object-MissingUpdated' => 'Oggetto mancante: aggiornato',
	'UI:CSVReport-Icon-Created' => 'Creato',
	'UI:CSVReport-Object-ToCreate' => 'L\'oggetto verrà creato',
	'UI:CSVReport-Object-Created' => 'Oggetto creato',
	'UI:CSVReport-Icon-Error' => 'Errore',
	'UI:CSVReport-Object-Error' => 'ERRORE: %1$s',
	'UI:CSVReport-Object-Ambiguous' => 'AMBIGUO: %1$s',
	'UI:CSVReport-Stats-Errors' => '%1$.0f %% degli oggetti caricati ha errori e verrà ignorato.',
	'UI:CSVReport-Stats-Created' => '%1$.0f %% degli oggetti caricati verrà creato.',
	'UI:CSVReport-Stats-Modified' => '%1$.0f %% degli oggetti caricati verrà modificato.',
	'UI:CSVExport:AdvancedMode' => 'Modalità avanzata',
	'UI:CSVExport:AdvancedMode+' => 'In modalità avanzata, vengono aggiunte alcune colonne all\'esportazione: l\'ID dell\'oggetto, l\'ID delle chiavi esterne e i loro attributi di conciliazione.',
	'UI:CSVExport:LostChars' => 'Problema di codifica',
	'UI:CSVExport:LostChars+' => 'Il file scaricato sarà codificato in %1$s. '.ITOP_APPLICATION_SHORT.' ha rilevato alcuni caratteri che non sono compatibili con questo formato. Questi caratteri verranno sostituiti da un sostituto (ad esempio, caratteri accentati che perderanno l\'accento) o verranno eliminati. Puoi copiare/incollare i dati dal tuo browser web. In alternativa, puoi contattare il tuo amministratore per cambiare la codifica (vedi parametro \'csv_file_default_charset\').',
	'UI:Audit:Title' => ITOP_APPLICATION_SHORT.' - Audit CMDB',
	'UI:Audit:Interactive:All:Title' => 'Risultati dell\'audit',
	'UI:Audit:Interactive:All:SubTitle' => 'Audit completo: include tutte le regole, tutte le categorie, tutti i domini',
	'UI:Audit:Interactive:All:BreadCrumb' => 'Audit completo',
	'UI:Audit:Interactive:All:BreadCrumb+' => 'Risultati dell\'audit per tutte le regole',
	'UI:Audit:Interactive:Categories:Title' => 'Risultati dell\'audit per le categorie: %1$s',
	'UI:Audit:Interactive:Categories:SubTitle' => 'Risultati dell\'audit per tutte le regole appartenenti a una delle %1$s categorie',
	'UI:Audit:Interactive:Categories:BreadCrumb' => 'Categorie',
	'UI:Audit:Interactive:Categories:BreadCrumb+' => 'Categorie dell\'audit: %1$s',
	'UI:Audit:Interactive:Domain:Title' => 'Risultati dell\'audit per il dominio: %1$s',
	'UI:Audit:Interactive:Domain:SubTitle' => 'Risultati dell\'audit per tutte le regole appartenenti a una categoria relativa al dominio: %1$s',
	'UI:Audit:Interactive:Domain:BreadCrumb' => '%1$s',
	'UI:Audit:Interactive:Domain:BreadCrumb+' => 'Audit per il dominio: %1$s',
	'UI:Audit:Interactive:Selection:Title' => 'Selezione di un audit',
	'UI:Audit:InteractiveAudit' => 'Audit interattivo',
	'UI:Audit:Interactive:Selection:SubTitle' => 'Seleziona un dominio per ottenere i risultati limitati a questo dominio o seleziona "Tutte le categorie" per ottenere un audit completo (può richiedere tempo o addirittura fallire se ci sono troppe informazioni da auditare)',
	'UI:Audit:Interactive:Selection:BreadCrumb' => 'Selezione',
	'UI:Audit:Interactive:Selection:BreadCrumb+' => 'Selezione di un audit da eseguire',
	'UI:Audit:Interactive:Selection:BadgeAll' => 'Tutte le categorie',
	'UI:Audit:Interactive:Button:Back' => 'Torna all\'audit',
	'UI:Audit:Interactive:Button:Configuration' => 'Configurazione audit',
	'UI:Audit:ViewRules' => 'Controlla le regole',
	'UI:Audit:HeaderAuditRule' => 'Regole di Audit',
	'UI:Audit:HeaderNbObjects' => '# Oggetti',
	'UI:Audit:HeaderNbErrors' => '# Errori',
	'UI:Audit:PercentageOk' => '% Ok',
	'UI:Audit:OqlError' => 'Errore OQL',
	'UI:Audit:Error:ValueNA' => 'n/a~~',
	'UI:Audit:ErrorIn_Rule' => 'Errore nella Regola',
	'UI:Audit:ErrorIn_Rule_Reason' => 'Errore OQL nella Regola %1$s: %2$s.',
	'UI:Audit:ErrorIn_Category' => 'Errore nella Categoria',
	'UI:Audit:ErrorIn_Category_Reason' => 'Errore OQL nella Categoria %1$s: %2$s.',
	'UI:Audit:AuditErrors' => 'Errori di Audit',
	'UI:Audit:Dashboard:ObjectsAudited' => 'Oggetti sottoposti ad audit',
	'UI:Audit:Dashboard:ObjectsInError' => 'Oggetti con errori',
	'UI:Audit:Dashboard:ObjectsValidated' => 'Oggetti validati',
	'UI:Audit:AuditCategory:Subtitle' => '%1$s errori su %2$s - %3$s%%',
	'UI:RunQuery:Title' => ITOP_APPLICATION_SHORT.' - Valutazione Query OQL',
	'UI:RunQuery:QueryExamples' => 'Esempi di Query',
	'UI:RunQuery:QueryResults' => 'Risultati Query',
	'UI:RunQuery:HeaderPurpose' => 'Scopo',
	'UI:RunQuery:HeaderPurpose+' => '',
	'UI:RunQuery:HeaderOQLExpression' => 'Espressioni OQL',
	'UI:RunQuery:HeaderOQLExpression+' => '',
	'UI:RunQuery:ExpressionToEvaluate' => 'Espressione da valutare: ',
	'UI:RunQuery:QueryArguments' => 'Argomenti Query',
	'UI:RunQuery:MoreInfo' => 'Maggiori informazioni sulla query: ',
	'UI:RunQuery:DevelopedQuery' => 'Espressione della query riqualificata:',
	'UI:RunQuery:SerializedFilter' => 'Filtro serializzato: ',
	'UI:RunQuery:DevelopedOQL' => 'OQL sviluppato',
	'UI:RunQuery:DevelopedOQLCount' => 'OQL sviluppato per il conteggio',
	'UI:RunQuery:ResultSQLCount' => 'SQL risultante per il conteggio',
	'UI:RunQuery:ResultSQL' => 'SQL risultante',
	'UI:RunQuery:Error' => 'Si è verificato un errore durante l\'esecuzione della query',
	'UI:Query:UrlForExcel' => 'URL da utilizzare per le query web di MS-Excel',
	'UI:Query:UrlV1' => 'L\'elenco dei campi è stato lasciato non specificato. La pagina <em>export-V2.php</em> non può essere invocata senza queste informazioni. Pertanto, l\'URL suggerito di seguito punta alla pagina legacy: <em>export.php</em>. Questa versione legacy dell\'esportazione ha il seguente limite: l\'elenco dei campi esportati può variare a seconda del formato di output e del modello di dati di '.ITOP_APPLICATION_SHORT.'.Se vuoi garantire che l\'elenco delle colonne esportate rimanga stabile nel lungo periodo, devi specificare un valore per l\'attributo "Campi" e utilizzare la pagina <em>export-V2.php</em>.',
	'UI:Schema:Title' => ITOP_APPLICATION_SHORT.' schema degli oggetti',
	'UI:Schema:TitleForClass' => '%1$s schema',
	'UI:Schema:CategoryMenuItem' => 'Categoria <b>%1$s</b>',
	'UI:Schema:Relationships' => 'Relazioni',
	'UI:Schema:AbstractClass' => 'Classe astratta: nessun oggetto da questa classe può essere istanziato.',
	'UI:Schema:NonAbstractClass' => 'Classe non-astratta: oggetti da questa classe possono essere istanziati.',
	'UI:Schema:ClassHierarchyTitle' => 'Gerarchia delle classi',
	'UI:Schema:AllClasses' => 'Tutte le classi',
	'UI:Schema:ExternalKey_To' => 'Chiave esterna  %1$s',
	'UI:Schema:Columns_Description' => 'Colonne: <em>%1$s</em>',
	'UI:Schema:Default_Description' => 'Default: "%1$s"',
	'UI:Schema:NullAllowed' => 'Null consentito',
	'UI:Schema:NullNotAllowed' => 'Null NON consentito',
	'UI:Schema:Attributes' => 'Attributi',
	'UI:Schema:AttributeCode' => 'Codice attributo',
	'UI:Schema:AttributeCode+' => '',
	'UI:Schema:Label' => 'Etichetta',
	'UI:Schema:Label+' => '',
	'UI:Schema:Type' => 'Tipo',
	'UI:Schema:Type+' => '',
	'UI:Schema:Origin' => 'Origine',
	'UI:Schema:Origin+' => '',
	'UI:Schema:Description' => 'Descrizione',
	'UI:Schema:Description+' => '',
	'UI:Schema:AllowedValues' => 'Valori consentiti',
	'UI:Schema:AllowedValues+' => '',
	'UI:Schema:MoreInfo' => 'Maggiori informazioni',
	'UI:Schema:MoreInfo+' => '',
	'UI:Schema:SearchCriteria' => 'Criteri di ricerca',
	'UI:Schema:FilterCode' => 'Codice di filtro',
	'UI:Schema:FilterCode+' => '',
	'UI:Schema:FilterDescription' => 'Descrizione',
	'UI:Schema:FilterDescription+' => '',
	'UI:Schema:AvailOperators' => 'Operatori disponibili',
	'UI:Schema:AvailOperators+' => '',
	'UI:Schema:ChildClasses' => 'Classi figlio',
	'UI:Schema:ReferencingClasses' => 'Classi di rifermento',
	'UI:Schema:RelatedClasses' => 'Classi correlate',
	'UI:Schema:LifeCycle' => 'Ciclo di vita',
	'UI:Schema:Triggers' => 'Triggers',
	'UI:Schema:Relation_Code_Description' => 'Relazione <em>%1$s</em> (%2$s)',
	'UI:Schema:RelationDown_Description' => 'Giù: %1$s',
	'UI:Schema:RelationUp_Description' => 'Su: %1$s',
	'UI:Schema:RelationPropagates' => '%1$s: propagato al livello %2$d, query: %3$s',
	'UI:Schema:RelationDoesNotPropagate' => '%1$s: non si propaga a (%2$d livelli), query: %3$s',
	'UI:Schema:Class_ReferencingClasses_From_By' => '%1$s fa riferimento la classe %2$s tramite il campo %3$s',
	'UI:Schema:Class_IsLinkedTo_Class_Via_ClassAndAttribute' => '%1$s è legata alla %2$s via %3$s::<em>%4$s</em>',
	'UI:Schema:Links:1-n' => 'Classi che puntano a %1$s (1:n links):',
	'UI:Schema:Links:n-n' => 'Classi legati alla %1$s (n:n links):',
	'UI:Schema:Links:All' => 'Grafico di tutte le classi correlate',
	'UI:Schema:NoLifeCyle' => 'Non vi è alcun ciclo di vita definito per questa classe.',
	'UI:Schema:LifeCycleTransitions' => 'Transizioni',
	'UI:Schema:LifeCyleAttributeOptions' => 'Opzioni per l\'attributo',
	'UI:Schema:LifeCycleHiddenAttribute' => 'Nascosto',
	'UI:Schema:LifeCycleReadOnlyAttribute' => 'Di sola lettura',
	'UI:Schema:LifeCycleMandatoryAttribute' => 'Obbigatorio',
	'UI:Schema:LifeCycleAttributeMustChange' => 'Deve cambiare',
	'UI:Schema:LifeCycleAttributeMustPrompt' => 'All\'utente verrà richiesto di modificare il valore',
	'UI:Schema:LifeCycleEmptyList' => 'lista vuota',
	'UI:Schema:ClassFilter' => 'Classe:',
	'UI:Schema:DisplayLabel' => 'Visualizzazione:',
	'UI:Schema:DisplaySelector/LabelAndCode' => 'Etichetta e codice',
	'UI:Schema:DisplaySelector/Label' => 'Etichetta',
	'UI:Schema:DisplaySelector/Code' => 'Codice',
	'UI:Schema:Attribute/Filter' => 'Filtro',
	'UI:Schema:DefaultNullValue' => 'Valore nullo predefinito: "%1$s"',
	'UI:Schema:Events' => 'Eventi',
	'UI:Schema:Events:Defined' => 'Eventi definiti',
	'UI:Schema:Events:NoEvent' => 'Nessun evento definito',
	'UI:Schema:Events:Listeners' => 'Ascoltatori di eventi',
	'UI:Schema:Events:NoListener' => 'Nessun ascoltatore di eventi',
	'UI:Schema:Events:Event' => 'Evento',
	'UI:Schema:Events:Description' => 'Descrizione',
	'UI:Schema:Events:Listener' => 'Ascoltatore',
	'UI:Schema:Events:Rank' => 'Grado',
	'UI:Schema:Events:Module' => 'Modulo',
	'UI:LinksWidget:Autocomplete+' => '',
	'UI:Edit:SearchQuery' => 'Seleziona una query predefinita',
	'UI:Edit:TestQuery' => 'Testa la query',
	'UI:Combo:SelectValue' => '--- seleziona un valore ---',
	'UI:Label:SelectedObjects' => 'oggetti selezionati: ',
	'UI:Label:AvailableObjects' => 'Oggetti disponibili: ',
	'UI:Link_Class_Attributes' => 'Attributi di %1$s',
	'UI:SelectAllToggle+' => '',
	'UI:AddObjectsOf_Class_LinkedWith_Class_Instance' => 'Aggiungi l\'oggeto %1$s collegato con %2$s: %3$s',
	'UI:AddObjectsOf_Class_LinkedWith_Class' => 'Aggiungi l\'oggeto %1$s al collegamento con %2$s',
	'UI:ManageObjectsOf_Class_LinkedWith_Class_Instance' => 'Gestisci l\'oggetto %1$s collegato con %2$s: %3$s',
	'UI:AddLinkedObjectsOf_Class' => 'Aggiungi %1$s',
	'UI:RemoveLinkedObjectsOf_Class' => 'Rimuovi gli oggetti selezionati',
	'UI:Message:EmptyList:UseAdd' => 'La lista è vuota, utilizzare il pulsante "Aggiungi ..." per aggiungere elementi.',
	'UI:Message:EmptyList:UseSearchForm' => 'Utilizza il modulo di ricerca qui sopra per cercare oggetti da aggiungere.',
	'UI:Wizard:FinalStepTitle' => 'Passo finale: la conferma',
	'UI:Title:DeletionOf_Object' => 'Soppressione di %1$s',
	'UI:Title:BulkDeletionOf_Count_ObjectsOf_Class' => 'Cancellazione collettiva di %1$d oggetti della classe %2$s',
	'UI:Delete:NotAllowedToDelete' => 'Non ti è permesso di eliminare l\'oggetto',
	'UI:Delete:NotAllowedToUpdate_Fields' => 'Non hai i permessi per aggiornare il seguente campo(i): %1$s',
	'UI:Error:ActionNotAllowed' => 'Non sei autorizzato a eseguire questa azione',
	'UI:Error:NotEnoughRightsToDelete' => 'Questo oggetto non può essere eliminato perché l\'utente corrente non dispone dei diritti necessari',
	'UI:Error:CannotDeleteBecause' => 'Questo oggetto non può essere eliminato perché: %1$s',
	'UI:Error:CannotDeleteBecauseOfDepencies' => 'Questo oggetto non può essere eliminato perché alcune operazioni manuali devono essere effettuate prima di questo',
	'UI:Error:CannotDeleteBecauseManualOpNeeded' => 'Questo oggetto non può essere eliminato perché alcune operazioni manuali devono essere effettuate prima di questo',
	'UI:Archive_User_OnBehalfOf_User' => '%1$s a nome di %2$s',
	'UI:Delete:Deleted' => 'eliminato',
	'UI:Delete:AutomaticallyDeleted' => 'eliminato automaticamente',
	'UI:Delete:AutomaticResetOf_Fields' => 'ripristino automatico dei campi: %1$s',
	'UI:Delete:CleaningUpRefencesTo_Object' => 'Pulizia di tutti i riferimenti a %1$s...',
	'UI:Delete:CleaningUpRefencesTo_Several_ObjectsOf_Class' => 'Pulizia di tutti i riferimenti a %1$d oggetti di classe %2$s...',
	'UI:Delete:Done+' => '',
	'UI:Delete:_Name_Class_Deleted' => '%1$s - %2$s eliminato.',
	'UI:Delete:ConfirmDeletionOf_Name' => 'Conferma l\'eliminazione di %1$s',
	'UI:Delete:ConfirmDeletionOf_Count_ObjectsOf_Class' => 'Conferma l\'eliminazione di %1$d oggetti di classe %2$s',
	'UI:Delete:CannotDeleteBecause' => 'Non può essere eliminato: %1$s',
	'UI:Delete:ShouldBeDeletedAtomaticallyButNotPossible' => 'Dovrebbe essere eliminato automaticamente, ma questo non è fattibile: %1$s',
	'UI:Delete:MustBeDeletedManuallyButNotPossible' => 'Deve essere eliminato manualmente, ma questo non è fattibile: %1$s',
	'UI:Delete:WillBeDeletedAutomatically' => 'Sarà eliminato automaticamente',
	'UI:Delete:MustBeDeletedManually' => 'Deve essere eliminato manualmente',
	'UI:Delete:CannotUpdateBecause_Issue' => 'Dovrebbero essere automaticamente aggiornati, ma: %1$s',
	'UI:Delete:WillAutomaticallyUpdate_Fields' => 'Sarà automaticamente aggiornato (reset: %1$s)',
	'UI:Delete:Count_Objects/LinksReferencing_Object' => '%1$d oggetti/link fanno riferimento a %2$s',
	'UI:Delete:Count_Objects/LinksReferencingTheObjects' => '%1$d oggetti / link fanno riferimento a alcuni degli oggetti da eliminare',
	'UI:Delete:ReferencesMustBeDeletedToEnsureIntegrity' => 'Per garantire l\'integrità del database, ogni riferimento dovrebbe essere ulteriormente eliminato',
	'UI:Delete:Consequence+' => '',
	'UI:Delete:SorryDeletionNotAllowed' => 'Spiacenti, non sei autorizzato a eliminare questo oggetto, vedere le spiegazioni di cui sopra',
	'UI:Delete:PleaseDoTheManualOperations' => 'Si prega di eseguire le operazioni manuali di cui sopra prima di richiedere la cancellazione di questo oggetto',
	'UI:Delect:Confirm_Object' => 'Si prega di confermare che si desidera eliminare %1$s.',
	'UI:Delect:Confirm_Count_ObjectsOf_Class' => 'Si prega di confermare che si desidera eliminare i seguenti oggetti %1$d della classe %2$s.',
	'UI:WelcomeToITop' => 'Benvenuto su '.ITOP_APPLICATION_SHORT, 'UI:DetailsPageTitle' => ITOP_APPLICATION_SHORT.' - %1$s - %2$s dettagli',
	'UI:ErrorPageTitle' => ITOP_APPLICATION_SHORT.' - Errore',
	'UI:ObjectDoesNotExist' => 'Spiacenti, questo oggetto non esiste (o non si è autorizzati per vederlo).',
	'UI:ObjectArchived' => 'Questo oggetto è stato archiviato. Si prega di abilitare la modalità archivio o contattare l\'amministratore.',
	'Tag:Archived' => 'Archiviato',
	'Tag:Archived+' => 'Può essere accesso solo in modalità archivio',
	'Tag:Obsolete' => 'Obsoleto',
	'Tag:Obsolete+' => 'Escluso dall\'analisi degli impatti e dai risultati di ricerca',
	'Tag:Synchronized' => 'Sincronizzato',
	'ObjectRef:Archived' => 'Archiviato',
	'ObjectRef:Obsolete' => 'Obsoleto',
	'UI:SearchResultsPageTitle' => ITOP_APPLICATION_SHORT.' - Risultati della ricerca',
	'UI:SearchResultsTitle' => 'Risultati della ricerca',
	'UI:SearchResultsTitle+' => 'Risultati della ricerca full-text',
	'UI:Search:NoSearch' => 'Nessuna ricerca effettuata',
	'UI:Search:NeedleTooShort' => 'La stringa di ricerca \\"%1$s\\" è troppo corta. Si prega di digitare almeno %2$d caratteri.',
	'UI:Search:Ongoing' => 'Ricerca per \\"%1$s\\"',
	'UI:Search:Enlarge' => 'Espandi la ricerca',
	'UI:FullTextSearchTitle_Text' => 'Risultati per "%1$s":',
	'UI:Search:Count_ObjectsOf_Class_Found' => 'Trovati %1$d oggetti della classe %2$s.',
	'UI:Search:NoObjectFound' => 'Nessun oggetto trovato.',
	'UI:ModificationPageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - %1$s - Modifica %2$s',
	'UI:ModificationTitle_Class_Object' => 'Modifica di %1$s: <span class=\\"hilite\\">%2$s</span>',
	'UI:ClonePageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - Clone %1$s - Modifica %2$s',
	'UI:CloneTitle_Class_Object' => 'Clone di %1$s: <span class=\\"hilite\\">%2$s</span>',
	'UI:CreationPageTitle_Class' => ITOP_APPLICATION_SHORT.' - Creazione di un nuovo %1$s ',
	'UI:CreationTitle_Class' => 'Creazione di un nuovo %1$s',
	'UI:SelectTheTypeOf_Class_ToCreate' => 'Seleziona il tipo di %1$s da creare:',
	'UI:Class_Object_NotUpdated' => 'Nessuna modifica rilevata, %1$s (%2$s)  <strong>non</strong> è stato aggiornato.',
	'UI:Class_Object_Updated' => '%1$s (%2$s) aggiornato.',
	'UI:BulkDeletePageTitle' => ITOP_APPLICATION_SHORT.' - Eliminazione di massa',
	'UI:BulkDeleteTitle' => 'Seleziona gli oggetti che si desidera eliminare:',
	'UI:PageTitle:ObjectCreated' => ITOP_APPLICATION_SHORT.' Oggetto Creato.',
	'UI:Title:Object_Of_Class_Created' => '%1$s - %2$s creato.',
	'UI:Toggle:CustomDashboard' => 'Personalizzato',
	'UI:Toggle:StandardDashboard' => 'Standard',
	'UI:Apply_Stimulus_On_Object_In_State_ToTarget_State' => 'Applicazione %1$s all\'oggetto: %2$s nello stato %3$s allo stato target: %4$s.',
	'UI:ObjectCouldNotBeWritten' => 'L\'oggetto non può essere scritto: %1$s',
	'UI:PageTitle:FatalError' => ITOP_APPLICATION_SHORT.' - Fatal Error',
	'UI:SystemIntrusion' => 'Accesso negato. Hai cercato di eseguire un\'operazione che non ti è consentita.',
	'UI:FatalErrorMessage' => 'Fatal error, '.ITOP_APPLICATION_SHORT.' non può continuare.',
	'UI:Error_Details' => 'Errore: %1$s.',
	'UI:PageTitle:ProfileProjections' => ITOP_APPLICATION_SHORT.' gestione degli utenti - proiezioni profilo',
	'UI:UserManagement:Class' => 'Classe',
	'UI:UserManagement:Class+' => '',
	'UI:UserManagement:ProjectedObject' => 'Oggetto',
	'UI:UserManagement:ProjectedObject+' => '',
	'UI:UserManagement:AnyObject' => '* qualsiasi *',
	'UI:UserManagement:User' => 'Utente',
	'UI:UserManagement:User+' => '',
	'UI:UserManagement:Action:Read' => 'Leggi',
	'UI:UserManagement:Action:Read+' => '',
	'UI:UserManagement:Action:Modify' => 'Modifica',
	'UI:UserManagement:Action:Modify+' => '',
	'UI:UserManagement:Action:Delete' => 'Cancella',
	'UI:UserManagement:Action:Delete+' => '',
	'UI:UserManagement:Action:BulkRead' => 'Leggi Bulk (Export)',
	'UI:UserManagement:Action:BulkRead+' => '',
	'UI:UserManagement:Action:BulkModify' => 'Modifica Bulk',
	'UI:UserManagement:Action:BulkModify+' => '',
	'UI:UserManagement:Action:BulkDelete' => 'Cancella Bulk ',
	'UI:UserManagement:Action:BulkDelete+' => '',
	'UI:UserManagement:Action:Stimuli' => 'Stimoli',
	'UI:UserManagement:Action:Stimuli+' => '',
	'UI:UserManagement:Action' => 'Azione',
	'UI:UserManagement:Action+' => '',
	'UI:UserManagement:TitleActions' => 'Azioni',
	'UI:UserManagement:Permission' => 'Autorizzazione',
	'UI:UserManagement:Permission+' => '',
	'UI:UserManagement:Attributes' => 'Attributi',
	'UI:UserManagement:ActionAllowed:Yes' => 'Si',
	'UI:UserManagement:ActionAllowed:No' => 'No',
	'UI:UserManagement:AdminProfile+' => '',
	'UI:UserManagement:NoLifeCycleApplicable' => 'N/A',
	'UI:UserManagement:NoLifeCycleApplicable+' => '',
	'UI:UserManagement:GrantMatrix' => 'Grant Matrix',
	'Menu:SystemTools' => 'Sistema',
	'UI:ChangeManagementMenu' => 'Gestione Cambi',
	'UI:ChangeManagementMenu+' => '',
	'UI:ChangeManagementMenu:Title' => 'Panoramica dei cambi',
	'UI-ChangeManagementMenu-ChangesByType' => 'Cambi per tipo',
	'UI-ChangeManagementMenu-ChangesByStatus' => 'Cambi per stato',
	'UI-ChangeManagementMenu-ChangesNotYetAssigned' => 'Cambi non ancora assegnati',
	'UI:ConfigurationManagementMenu' => 'Gestione Configurazione',
	'UI:ConfigurationManagementMenu+' => '',
	'UI:ConfigurationManagementMenu:Title' => 'Panoramica delle infrastrutture',
	'UI-ConfigurationManagementMenu-InfraByType' => 'Oggetti infrastruttutura per tipo',
	'UI-ConfigurationManagementMenu-InfraByStatus' => 'Oggetti infrastruttutura per stato',
	'UI:ConfigMgmtMenuOverview:Title' => 'Cruscotto per Gestione configurazione',
	'UI-ConfigMgmtMenuOverview-FunctionalCIbyStatus' => 'Configuration Items per stato',
	'UI-ConfigMgmtMenuOverview-FunctionalCIByType' => 'Configuration Items per tipo',
	'UI:RequestMgmtMenuOverview:Title' => 'Cruscotto per Gestione Richieste',
	'UI-RequestManagementOverview-RequestByService' => 'Richieste degli utenti per servizio',
	'UI-RequestManagementOverview-RequestByPriority' => 'Richieste degli utenti per priorità',
	'UI-RequestManagementOverview-RequestUnassigned' => 'Richieste degli utenti non ancora assegnate ad un agente',
	'UI:IncidentMgmtMenuOverview:Title' => 'Cruscotto Gestione degli Incidenti',
	'UI-IncidentManagementOverview-IncidentByService' => 'Incidenti per servizio',
	'UI-IncidentManagementOverview-IncidentByPriority' => 'Incidenti per  priorità',
	'UI-IncidentManagementOverview-IncidentUnassigned' => 'Incidenti non ancora assegnati ad un agente',
	'UI:ChangeMgmtMenuOverview:Title' => 'Cruscotto per Gestione dei Cambi',
	'UI-ChangeManagementOverview-ChangeByType' => 'Cambi per tipo',
	'UI-ChangeManagementOverview-ChangeUnassigned' => 'Cambi non ancora assegnati ad un agente',
	'UI-ChangeManagementOverview-ChangeWithOutage' => 'Interruzioni dovute ai cambi',
	'UI:ServiceMgmtMenuOverview:Title' => 'Cruscotto per Gestione dei Cambi',
	'UI-ServiceManagementOverview-CustomerContractToRenew' => 'Contratti con i clienti da rinnovarsi in 30 giorni',
	'UI-ServiceManagementOverview-ProviderContractToRenew' => 'Contratti con i fornitori da rinnovarsi in 30 giorni',
	'UI:ContactsMenu' => 'Contatti',
	'UI:ContactsMenu+' => '',
	'UI:ContactsMenu:Title' => 'Contatti Panoramica',
	'UI-ContactsMenu-ContactsByLocation' => 'Contatti per localizzazione',
	'UI-ContactsMenu-ContactsByType' => 'Contatti per tipo',
	'UI-ContactsMenu-ContactsByStatus' => 'Contatti per stato',
	'UI:NotificationsMenu:Title' => 'Configurazione delle Notifiche',
	'UI:NotificationsMenu:Help' => 'Aiuto',
	'UI:NotificationsMenu:HelpContent' => '<p>In '.ITOP_APPLICATION_SHORT.' le notifiche sono completamente personalizzabili. Esse si basano su due serie di oggetti: <i>trigger e azioni</i>.</p>
<p><i>I <b>trigger</b></i> definiscono quando verrà eseguita una notifica. Ci sono diversi trigger come parte del nucleo di '.ITOP_APPLICATION_SHORT.', ma altri possono essere forniti da estensioni:
<ol>
	 <li>Alcuni trigger vengono eseguiti quando un oggetto della classe specificata viene <b>creato</b>, <b>aggiornato</b> o <b>cancellato</b>.</li>
	 <li>Alcuni trigger vengono eseguiti quando un oggetto di una data classe <b>entra</b> o <b>lascia</b> uno <b>stato specificato</b>.</li>
	 <li>Alcuni trigger vengono eseguiti quando una <b>soglia</b> su <b>TTO</b> o <b>TTR</b> è stata <b>raggiunta</b>.</li>
</ol>
</p>
<p>
<i><b>Azioni</b></i> definiscono le azioni da eseguire quando i trigger vengono attivati. Per ora ci sono solo due tipi di azioni:
<ol>
	<li>Invio di un messaggio email: Tali azioni definiscono anche il modello da utilizzare per l\'invio dell\'email, nonché gli altri parametri del messaggio come i destinatari, l\'importanza, ecc.<br />
	Una pagina speciale: <a href="../setup/email.test.php" target="_blank">email.test.php</a> è disponibile per il test e la risoluzione dei problemi di configurazione della posta PHP.</li>
	<li>Invio di un messaggio newsroom: Visualizzare una notizia agli utenti direttamente nell\'applicazione tramite la newsroom (icona della campanella nel menu a sinistra)</li>
	<li>Webhook in uscita: Consentire l\'integrazione con un\'applicazione di terze parti inviando dati strutturati a un URL definito.</li>
</ol>
</p>
<p>Per essere eseguite, le azioni devono essere associate ai trigger.
Quando è associata a un trigger, a ogni azione è assegnato un numero "ordine", che specifica in quale ordine le azioni devono essere eseguite.</p>',
	'UI:NotificationsMenu:Triggers' => 'Triggers',
	'UI:NotificationsMenu:AvailableTriggers' => 'Triggers Disponibili',
	'UI:NotificationsMenu:OnCreate' => 'Quando un oggetto viene creato',
	'UI:NotificationsMenu:OnStateEnter' => 'Quando un oggetto viene creato',
	'UI:NotificationsMenu:OnStateLeave' => 'Quando un oggetto lascia un determinato stato',
	'UI:NotificationsMenu:Actions' => 'Azioni',
	'UI:NotificationsMenu:Actions:ActionEmail' => 'Azioni email',
	'UI:NotificationsMenu:Actions:ActionWebhook' => 'Azioni webhook (integrazioni in uscita)',
	'UI:NotificationsMenu:Actions:Action' => 'Altre azioni',
	'UI:NotificationsMenu:AvailableActions' => 'Azioni disponibili',
	'Menu:TagAdminMenu' => 'Configurazione dei tag',
	'Menu:TagAdminMenu+' => 'Gestione dei valori dei tag',
	'UI:TagAdminMenu:Title' => 'Configurazione dei tag',
	'UI:TagAdminMenu:NoTags' => 'Nessun campo Tag configurato',
	'UI:TagSetFieldData:Error' => 'Errore: %1$s',
	'UI:iTopVersion:Short' => 'Versione %1$s %2$s',
	'UI:iTopVersion:Long' => 'Versione %1$s %2$s-%3$s costruita il %4$s',
	'UI:PropertiesTab' => 'Proprietà',
	'UI:OpenDocumentInNewWindow_' => 'Aprire',
	'UI:DownloadDocument_' => 'Scaricare',
	'UI:Document:NoPreview' => 'Non è disponibile un\'anteprima per questo tipo di documento',
	'UI:Download-CSV' => 'Download %1$s',
	'UI:DeadlineMissedBy_duration' => 'Mancati %1$s',
	'UI:Deadline_LessThan1Min' => '< 1 min',
	'UI:Deadline_Minutes' => '%1$d min',
	'UI:Deadline_Hours_Minutes' => '%1$dh %2$dmin',
	'UI:Deadline_Days_Hours_Minutes' => '%1$dg %2$dh %3$dmin',
	'UI:Help' => 'Aiuto',
	'UI:PasswordConfirm' => 'Conferma',
	'UI:BeforeAdding_Class_ObjectsSaveThisObject' => 'Prima di aggiungere più %1$s oggetti, salva questo oggetto.',
	'UI:DisplayThisMessageAtStartup' => 'Visualizza questo messaggio in fase di avvio',
	'UI:Display_X_ItemsPerPage' => 'Mostra %1$s elementi per pagina',
	'UI:RelationshipGraph' => 'Visualizzazione grafica',
	'UI:RelationshipList' => 'Lista',
	'UI:RelationGroups' => 'Gruppi',
	'UI:OperationCancelled' => 'Operazione Annullata',
	'UI:ElementsDisplayed' => 'Filtro',
	'UI:RelationGroupNumber_N' => 'Gruppo #%1$d',
	'UI:Relation:ExportAsPDF' => 'Esporta come PDF...',
	'UI:RelationOption:GroupingThreshold' => 'Soglia di raggruppamento',
	'UI:Relation:AdditionalContextInfo' => 'Informazioni di contesto aggiuntive',
	'UI:Relation:NoneSelected' => 'Nessuno',
	'UI:Relation:Zoom' => 'Zoom',
	'UI:Relation:ExportAsAttachment' => 'Esporta come Allegato...',
	'UI:Relation:DrillDown' => 'Dettagli...',
	'UI:Relation:PDFExportOptions' => 'Opzioni di Esportazione in PDF',
	'UI:Relation:AttachmentExportOptions_Name' => 'Opzioni per l\'Allegato a %1$s',
	'UI:RelationOption:Untitled' => 'Senza titolo',
	'UI:Relation:Key' => 'Chiave',
	'UI:Relation:Comments' => 'Commenti',
	'UI:RelationOption:Title' => 'Titolo',
	'UI:RelationOption:IncludeList' => 'Includi l\'elenco degli oggetti',
	'UI:RelationOption:Comments' => 'Commenti',
	'UI:Button:Export' => 'Esporta',
	'UI:Relation:PDFExportPageFormat' => 'Formato Pagina',
	'UI:PageFormat_A3' => 'A3',
	'UI:PageFormat_A4' => 'A4',
	'UI:PageFormat_Letter' => 'Lettera',
	'UI:Relation:PDFExportPageOrientation' => 'Orientamento Pagina',
	'UI:PageOrientation_Portrait' => 'Verticale',
	'UI:PageOrientation_Landscape' => 'Orizzontale',
	'UI:RelationTooltip:Redundancy' => 'Ridondanza',
	'UI:RelationTooltip:ImpactedItems_N_of_M' => '# di elementi coinvolti: %1$d / %2$d',
	'UI:RelationTooltip:CriticalThreshold_N_of_M' => 'Soglia critica: %1$d / %2$d',
	'Portal:Title' => 'Portale Utente '.ITOP_APPLICATION_SHORT, 'Portal:NoRequestMgmt' => 'Caro %1$s, sei stato reindirizzato a questa pagina perché il tuo account è configurato con il profilo "Utente del portale". Purtroppo, '.ITOP_APPLICATION_SHORT.' non è stato installato con la funzionalità "Gestione delle richieste". Si prega di contattare l\'amministratore.',
	'Portal:Refresh' => 'Aggiorna',
	'Portal:Back' => 'Indietro',
	'Portal:WelcomeUserOrg' => 'Benvenuto %1$s, da %2$s',
	'Portal:TitleDetailsFor_Request' => 'Dettagli per la richiesta',
	'Portal:ShowOngoing' => 'Mostra richieste aperte',
	'Portal:ShowClosed' => 'Mostra richieste chiuse',
	'Portal:CreateNewRequest' => 'Crea una nuova richiesta',
	'Portal:CreateNewRequestItil' => 'Crea una nuova richiesta',
	'Portal:CreateNewIncidentItil' => 'Crea un nuovo rapporto di incidente',
	'Portal:ChangeMyPassword' => 'Cambia la mia password',
	'Portal:Disconnect' => 'Disconnetti',
	'Portal:OpenRequests' => 'Le mie richieste aperte',
	'Portal:ClosedRequests' => 'Le mie richieste chiuse',
	'Portal:ResolvedRequests' => 'Le mie richieste risolte',
	'Portal:SelectService' => 'Seleziona un servizio dal catalogo:',
	'Portal:PleaseSelectOneService' => 'Si prega di selezionare un servizio',
	'Portal:SelectSubcategoryFrom_Service' => 'Seleziona una sotto-categoria per il servizio %1$s:',
	'Portal:PleaseSelectAServiceSubCategory' => 'Si prega di selezionare una delle sottocategorie',
	'Portal:DescriptionOfTheRequest' => 'Inserisci la descrizione della tua richiesta:',
	'Portal:TitleRequestDetailsFor_Request' => 'Dettagli per la richiesta %1$s:',
	'Portal:NoOpenRequest' => 'Nessuna richiesta in questa categoria.',
	'Portal:NoClosedRequest' => 'Nessuna richiesta in questa categoria.',
	'Portal:Button:ReopenTicket' => 'Riapri questo ticket',
	'Portal:Button:CloseTicket' => 'Chiudi questo ticket',
	'Portal:Button:UpdateRequest' => 'Aggiorna la richiesta',
	'Portal:EnterYourCommentsOnTicket' => 'Inserisci il tuo commento sulla risoluzione di questo ticket:',
	'Portal:ErrorNoContactForThisUser' => 'Errore: l\'utente corrente non è associato a un Contatto/Persona. Si prega di contattare l\'amministratore.',
	'Portal:Attachments' => 'Allegati',
	'Portal:AddAttachment' => 'Aggiungi allegati',
	'Portal:RemoveAttachment' => 'Rimuovi allegati',
	'Portal:Attachment_No_To_Ticket_Name' => 'Allegato #%1$d a %2$s (%3$s)',
	'Portal:SelectRequestTemplate' => 'Seleziona un modello per %1$s',
	'Enum:Undefined' => 'Non definito',
	'UI:DurationForm_Days_Hours_Minutes_Seconds' => '%1$s Giorni %2$s Ore %3$s Minuti %4$s Secondi',
	'UI:ModifyAllPageTitle' => 'Modifica Tutto',
	'UI:Modify_ObjectsOf_Class' => 'Modifica oggetti della classe %1$s',
	'UI:Modify_N_ObjectsOf_Class' => 'Modifica %1$d oggetto della classe %2$s',
	'UI:Modify_M_ObjectsOf_Class_OutOf_N' => 'Modifica %1$d oggetto della classe %2$s fuori da %3$d',
	'UI:Menu:ModifyAll' => 'Modifica...',
	'UI:Menu:ModifyAll_Class' => 'Modifica oggetti %1$s...',
	'UI:Menu:ModifyAll_Link' => 'Modifica %1$s...',
	'UI:Menu:ModifyAll_Remote' => 'Modifica %1$s...',
	'UI:Button:ModifyAll' => 'Modifica tutto',
	'UI:Button:PreviewModifications' => 'Anteprima Modifiche >>',
	'UI:ModifiedObject' => 'Oggetto Modificato',
	'UI:BulkModifyStatus' => 'Operazioni',
	'UI:BulkModifyStatus+' => '',
	'UI:BulkModifyErrors' => 'Errori (eventuali)',
	'UI:BulkModifyErrors+' => '',
	'UI:BulkModifyStatusOk' => 'Ok',
	'UI:BulkModifyStatusError' => 'Errore',
	'UI:BulkModifyStatusModified' => 'Modificato',
	'UI:BulkModifyStatusSkipped' => 'Saltato',
	'UI:BulkModify_Count_DistinctValues' => '%1$d valori distinti:',
	'UI:BulkModify:Value_Exists_N_Times' => '%1$s, %2$d volta(e)',
	'UI:BulkModify:N_MoreValues' => '%1$d più valori...',
	'UI:AttemptingToSetAReadOnlyAttribute_Name' => 'Tentativo di impostare il campo di sola lettura: %1$s',
	'UI:FailedToApplyStimuli' => 'L\'azione non è riuscita.',
	'UI:StimulusModify_N_ObjectsOf_Class' => '%1$s: Modifica %2$d oggetti della classe %3$s',
	'UI:CaseLogTypeYourTextHere' => 'Digitare il tuo testo qui:',
	'UI:CaseLog:Header_Date_UserName' => '%1$s - %2$s:',
	'UI:CaseLog:InitialValue' => 'Valore iniziale:',
	'UI:AttemptingToSetASlaveAttribute_Name' => 'Il campo %1$s on è scrivibile, perché è comandato dalla sincronizzazione dei dati. Valore non impostato.',
	'UI:ActionNotAllowed' => 'Non hai i permessi per eseguire questa azione su questi oggetti.',
	'UI:BulkAction:NoObjectSelected' => 'Si prega di selezionare almeno un oggetto per eseguire questa operazione',
	'UI:AttemptingToChangeASlaveAttribute_Name' => 'Il campo %1$s on è scrivibile, perché è comandato dalla sincronizzazione dei dati. Valore rimane invariato.',
	'UI:Pagination:HeaderSelection' => 'Totale: %1$s oggetti (%2$s oggetti selezionati).',
	'UI:Pagination:HeaderNoSelection' => 'Totale: %1$s oggetti.',
	'UI:Pagination:PageSize' => '%1$s oggetti per pagina',
	'UI:Pagination:PagesLabel' => 'Pagine:',
	'UI:Pagination:All' => 'Tutto',
	'UI:HierarchyOf_Class' => 'Gerarchia di %1$s',
	'UI:Preferences' => 'Preferenze...',
	'UI:ArchiveModeOn' => 'Attiva la modalità archivio',
	'UI:ArchiveModeOff' => 'Disattiva la modalità archivio',
	'UI:ArchiveMode:Banner' => 'Modalità archivio',
	'UI:ArchiveMode:Banner+' => 'Gli oggetti archiviati sono visibili, e non è consentita alcuna modifica',
	'UI:FavoriteOrganizations' => 'Organizzazioni Preferite',
	'UI:FavoriteOrganizations+' => 'Seleziona nell\'elenco sottostante le organizzazioni che desideri vedere nel menu a discesa per un accesso rapido. Nota che questa non è una impostazione di sicurezza, gli oggetti di qualsiasi organizzazione sono comunque visibili e accessibili selezionando "Tutte le Organizzazioni" nel menu a discesa.',
	'UI:FavoriteLanguage' => 'Lingua dell\'Interfaccia Utente',
	'UI:Favorites:SelectYourLanguage' => 'Seleziona la tua lingua preferita',
	'UI:FavoriteOtherSettings' => 'Altre Impostazioni',
	'UI:Favorites:Default_X_ItemsPerPage' => 'Lunghezza predefinita: %1$s oggetti per pagina',
	'UI:Favorites:ShowObsoleteData' => 'Mostra dati obsoleti',
	'UI:Favorites:ShowObsoleteData+' => 'Mostra dati obsoleti nei risultati della ricerca e nelle liste degli oggetti da selezionare',
	'UI:NavigateAwayConfirmationMessage' => 'Eventuali modifiche saranno scartate. Continuare comunque?',
	'UI:CancelConfirmationMessage' => 'Perderai le tue modifiche. Continuare comunque?',
	'UI:AutoApplyConfirmationMessage' => 'Alcune modifiche non sono ancora state applicate. Vuoi che itop le prenda in considerazione?',
	'UI:Create_Class_InState' => 'Crea il %1$s nello stato: ',
	'UI:OrderByHint_Values' => 'Ordina per: %1$s',
	'UI:Menu:AddToDashboard' => 'Aggiungi alla Dashboard...',
	'UI:Button:Refresh' => 'Ricarica',
	'UI:Button:GoPrint' => 'Stampa...',
	'UI:ExplainPrintable' => 'Clicca sull\'icona %1$s per nascondere elementi dalla stampa.<br/>Utilizza la funzione "anteprima di stampa" del tuo browser per una preview prima di stampare.<br/>Nota: questa intestazione e gli altri controlli di configurazione non verranno stampati.',
	'UI:PrintResolution:FullSize' => 'Dimensione intera',
	'UI:PrintResolution:A4Portrait' => 'A4 Verticale',
	'UI:PrintResolution:A4Landscape' => 'A4 Orizzontale',
	'UI:PrintResolution:LetterPortrait' => 'Letter Verticale',
	'UI:PrintResolution:LetterLandscape' => 'Letter Orizzontale',
	'UI:Toggle:SwitchToStandardDashboard' => 'Passa alla dashboard standard',
	'UI:Toggle:SwitchToCustomDashboard' => 'Passa alla dashboard personalizzata',
	'UI:ConfigureThisList' => 'Configura questa lista...',
	'UI:ListConfigurationTitle' => 'Configurazione della Lista',
	'UI:ColumnsAndSortOrder' => 'Colonne e ordine di ordinamento:',
	'UI:UseDefaultSettings' => 'Usa le Impostazioni Predefinite',
	'UI:UseSpecificSettings' => 'Usa le Seguenti Impostazioni:',
	'UI:Display_X_ItemsPerPage_prefix' => 'Visualizza',
	'UI:Display_X_ItemsPerPage_suffix' => 'oggetti per pagina',
	'UI:UseSavetheSettings' => 'Salva le Impostazioni',
	'UI:OnlyForThisList' => 'Solo per questa lista',
	'UI:ForAllLists' => 'Predefinito per tutte le liste',
	'UI:ExtKey_AsLink' => '%1$s (Link)',
	'UI:ExtKey_AsFriendlyName' => '%1$s (Nome Amichevole)',
	'UI:ExtField_AsRemoteField' => '%1$s (%2$s)',
	'UI:Button:MoveUp' => 'Sposta Su',
	'UI:Button:MoveDown' => 'Sposta Giù',
	'UI:OQL:UnknownClassAndFix' => 'Classe sconosciuta \\"%1$s\\". Potresti provare \\"%2$s\\" al suo posto.',
	'UI:OQL:UnknownClassNoFix' => 'Classe sconosciuta \\"%1$s\\"',
	'UI:Dashboard:EditCustom' => 'Modifica versione personalizzata...',
	'UI:Dashboard:CreateCustom' => 'Crea una versione personalizzata...',
	'UI:Dashboard:DeleteCustom' => 'Elimina versione personalizzata...',
	'UI:Dashboard:Edit' => 'Modifica questa pagina...',
	'UI:Dashboard:RevertConfirm' => 'Tutte le modifiche apportate alla versione originale saranno perse. Conferma che desideri farlo.',
	'UI:ExportDashBoard' => 'Esporta in un file',
	'UI:ImportDashBoard' => 'Importa da un file...',
	'UI:ImportDashboardTitle' => 'Importa Da un File',
	'UI:ImportDashboardText' => 'Seleziona un file di dashboard da importare:',
	'UI:Dashboard:Actions' => 'Azioni della Dashboard',
	'UI:Dashboard:NotUpToDateUntilContainerSaved' => 'Questa dashboard visualizza informazioni che non includono le modifiche in corso.',
	'UI:Dashboard:Revert' => 'Ripristina alla versione originale...',
	'UI:DashletCreation:Title' => 'Crea un nuovo Dashlet',
	'UI:DashletCreation:Dashboard' => 'Dashboard',
	'UI:DashletCreation:DashletType' => 'Tipo di Dashlet',
	'UI:DashletCreation:EditNow' => 'Modifica la Dashboard',
	'UI:DashboardEdit:Title' => 'Editor della Dashboard',
	'UI:DashboardEdit:DashboardTitle' => 'Titolo',
	'UI:DashboardEdit:AutoReload' => 'Aggiornamento automatico',
	'UI:DashboardEdit:AutoReloadSec' => 'Intervallo di aggiornamento automatico (secondi)',
	'UI:DashboardEdit:AutoReloadSec+' => 'Il minimo consentito è %1$d secondi',
	'UI:DashboardEdit:Revert' => 'Annulla',
	'UI:DashboardEdit:Apply' => 'Applica',
	'UI:DashboardEdit:Layout' => 'Layout',
	'UI:DashboardEdit:Properties' => 'Proprietà della Dashboard',
	'UI:DashboardEdit:Dashlets' => 'Dashlet disponibili',
	'UI:DashboardEdit:DashletProperties' => 'Proprietà del Dashlet',
	'UI:Form:Property' => 'Proprietà',
	'UI:Form:Value' => 'Valore',
	'UI:DashletUnknown:Label' => 'Sconosciuto',
	'UI:DashletUnknown:Description' => 'Dashlet sconosciuto (potrebbe essere stato disinstallato)',
	'UI:DashletUnknown:RenderText:View' => 'Impossibile renderizzare questo dashlet.',
	'UI:DashletUnknown:RenderText:Edit' => 'Impossibile renderizzare questo dashlet (classe "%1$s"). Verifica con il tuo amministratore se è ancora disponibile.',
	'UI:DashletUnknown:RenderNoDataText:Edit' => 'Nessuna anteprima disponibile per questo dashlet (classe "%1$s").',
	'UI:DashletUnknown:Prop-XMLConfiguration' => 'Configurazione (mostrata come XML grezzo)',
	'UI:DashletProxy:Label' => 'Proxy',
	'UI:DashletProxy:Description' => 'Dashlet proxy',
	'UI:DashletProxy:RenderNoDataText:Edit' => 'Nessuna anteprima disponibile per questo dashlet di terze parti (classe "%1$s").',
	'UI:DashletProxy:Prop-XMLConfiguration' => 'Configurazione (mostrata come XML grezzo)',
	'UI:DashletPlainText:Label' => 'Testo',
	'UI:DashletPlainText:Description' => 'Testo semplice (senza formattazione)',
	'UI:DashletPlainText:Prop-Text' => 'Testo',
	'UI:DashletPlainText:Prop-Text:Default' => 'Inserisci del testo qui...',
	'UI:DashletObjectList:Label' => 'Elenco oggetti',
	'UI:DashletObjectList:Description' => 'Dashlet elenco oggetti',
	'UI:DashletObjectList:Prop-Title' => 'Titolo',
	'UI:DashletObjectList:Prop-Query' => 'Query',
	'UI:DashletObjectList:Prop-Menu' => 'Menu',
	'UI:DashletGroupBy:Prop-Title' => 'Titolo',
	'UI:DashletGroupBy:Prop-Query' => 'Query',
	'UI:DashletGroupBy:Prop-Style' => 'Stile',
	'UI:DashletGroupBy:Prop-GroupBy' => 'Raggruppa per...',
	'UI:DashletGroupBy:Prop-GroupBy:Hour' => 'Ora di %1$s (0-23)',
	'UI:DashletGroupBy:Prop-GroupBy:Month' => 'Mese di %1$s (1 - 12)',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfWeek' => 'Giorno della settimana per %1$s',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfMonth' => 'Giorno del mese per %1$s',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Hour' => '%1$s (ora)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Month' => '%1$s (mese)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfWeek' => '%1$s (giorno della settimana)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfMonth' => '%1$s (giorno del mese)',
	'UI:DashletGroupBy:MissingGroupBy' => 'Seleziona il campo su cui raggruppare gli oggetti',
	'UI:DashletGroupByPie:Label' => 'Grafico a torta',
	'UI:DashletGroupByPie:Description' => 'Grafico a torta',
	'UI:DashletGroupByBars:Label' => 'Grafico a barre',
	'UI:DashletGroupByBars:Description' => 'Grafico a barre',
	'UI:DashletGroupByTable:Label' => 'Raggruppa per (tabella)',
	'UI:DashletGroupByTable:Description' => 'Elenco (Raggruppato per un campo)',
	'UI:DashletGroupBy:Prop-Function' => 'Funzione di aggregazione',
	'UI:DashletGroupBy:Prop-FunctionAttribute' => 'Attributo di funzione',
	'UI:DashletGroupBy:Prop-OrderDirection' => 'Direzione',
	'UI:DashletGroupBy:Prop-OrderField' => 'Ordina per',
	'UI:DashletGroupBy:Prop-Limit' => 'Limite',
	'UI:DashletGroupBy:Order:asc' => 'Crescente',
	'UI:DashletGroupBy:Order:desc' => 'Decrescente',
	'UI:GroupBy:count' => 'Conteggio',
	'UI:GroupBy:count+' => 'Numero di elementi',
	'UI:GroupBy:sum' => 'Somma',
	'UI:GroupBy:sum+' => 'Somma di %1$s',
	'UI:GroupBy:avg' => 'Media',
	'UI:GroupBy:avg+' => 'Media di %1$s',
	'UI:GroupBy:min' => 'Minimo',
	'UI:GroupBy:min+' => 'Minimo di %1$s',
	'UI:GroupBy:max' => 'Massimo',
	'UI:GroupBy:max+' => 'Massimo di %1$s',
	'UI:DashletHeaderStatic:Label' => 'Intestazione',
	'UI:DashletHeaderStatic:Description' => 'Visualizza un separatore orizzontale',
	'UI:DashletHeaderStatic:Prop-Title' => 'Titolo',
	'UI:DashletHeaderStatic:Prop-Title:Default' => 'Contatti',
	'UI:DashletHeaderStatic:Prop-Icon' => 'Icona',
	'UI:DashletHeaderDynamic:Label' => 'Intestazione con statistiche',
	'UI:DashletHeaderDynamic:Description' => 'Intestazione con statistiche (raggruppate per...)',
	'UI:DashletHeaderDynamic:Prop-Title' => 'Titolo',
	'UI:DashletHeaderDynamic:Prop-Title:Default' => 'Contatti',
	'UI:DashletHeaderDynamic:Prop-Icon' => 'Icona',
	'UI:DashletHeaderDynamic:Prop-Subtitle' => 'Sottotitolo',
	'UI:DashletHeaderDynamic:Prop-Subtitle:Default' => 'Contatti',
	'UI:DashletHeaderDynamic:Prop-Query' => 'Query',
	'UI:DashletHeaderDynamic:Prop-GroupBy' => 'Raggruppa per',
	'UI:DashletHeaderDynamic:Prop-Values' => 'Valori',
	'UI:DashletBadge:Label' => 'Badge',
	'UI:DashletBadge:Description' => 'Icona oggetto con nuova/ricerca',
	'UI:DashletBadge:Prop-Class' => 'Classe',
	'DayOfWeek-Sunday' => 'Domenica',
	'DayOfWeek-Monday' => 'Lunedì',
	'DayOfWeek-Tuesday' => 'Martedì',
	'DayOfWeek-Wednesday' => 'Mercoledì',
	'DayOfWeek-Thursday' => 'Giovedì',
	'DayOfWeek-Friday' => 'Venerdì',
	'DayOfWeek-Saturday' => 'Sabato',
	'Month-01' => 'Gennaio',
	'Month-02' => 'Febbraio',
	'Month-03' => 'Marzo',
	'Month-04' => 'Aprile',
	'Month-05' => 'Maggio',
	'Month-06' => 'Giugno',
	'Month-07' => 'Luglio',
	'Month-08' => 'Agosto',
	'Month-09' => 'Settembre',
	'Month-10' => 'Ottobre',
	'Month-11' => 'Novembre',
	'Month-12' => 'Dicembre',
	'DayOfWeek-Sunday-Min' => 'Su',
	'DayOfWeek-Monday-Min' => 'Lu',
	'DayOfWeek-Tuesday-Min' => 'Ma',
	'DayOfWeek-Wednesday-Min' => 'Me',
	'DayOfWeek-Thursday-Min' => 'Gi',
	'DayOfWeek-Friday-Min' => 'Ve',
	'DayOfWeek-Saturday-Min' => 'Sa',
	'Month-01-Short' => 'Gen',
	'Month-02-Short' => 'Feb',
	'Month-03-Short' => 'Mar',
	'Month-04-Short' => 'Apr',
	'Month-05-Short' => 'Mag',
	'Month-06-Short' => 'Giu',
	'Month-07-Short' => 'Lug',
	'Month-08-Short' => 'Ago',
	'Month-09-Short' => 'Set',
	'Month-10-Short' => 'Ott',
	'Month-11-Short' => 'Nov',
	'Month-12-Short' => 'Dic',
	'Calendar-FirstDayOfWeek' => '0',
	'UI:Menu:ShortcutList' => 'Crea una scorciatoia...',
	'UI:Menu:FilterList' => 'Visualizza elenco con criteri di ricerca',
	'UI:ShortcutRenameDlg:Title' => 'Rinomina la scorciatoia',
	'UI:ShortcutListDlg:Title' => 'Crea una scorciatoia per l\'elenco',
	'UI:ShortcutDelete:Confirm' => 'Si prega di confermare la cancellazione delle scorciatoie.',
	'UI:ObjectShortcutInsert' => 'Inserisci scorciatoia oggetto',
	'Class:Shortcut' => 'Scorciatoia',
	'Class:Shortcut+' => '~~',
	'Class:Shortcut/Attribute:name' => 'Nome',
	'Class:Shortcut/Attribute:name+' => 'Etichetta utilizzata nel menu e nel titolo della pagina',
	'Class:ShortcutOQL' => 'Scorciatoia risultati di ricerca',
	'Class:ShortcutOQL+' => '~~',
	'Class:ShortcutOQL/Attribute/auto_reload_sec/tip' => 'Il minimo consentito è di %1$d secondi',
	'Class:ShortcutOQL/Attribute:oql' => 'Query',
	'Class:ShortcutOQL/Attribute:oql+' => 'OQL che definisce l\'elenco di oggetti da cercare',
	'Class:TagSetFieldData/Attribute:finalclass' => 'Classe del tag',
	'Class:TagSetFieldData/Attribute:obj_attcode' => 'Codice del campo',
	'Class:TagSetFieldData/Attribute:obj_class' => 'Classe dell\'oggetto',
	'Class:ShortcutOQL/Attribute:auto_reload' => 'Aggiornamento automatico',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:none' => 'Disabilitato',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:custom' => 'Tariffa personalizzata',
	'Class:ShortcutOQL/Attribute:auto_reload_sec' => 'Intervallo di aggiornamento automatico (secondi)',
	'Class:ShortcutOQL/Attribute:auto_reload_sec/tip' => 'Il minimo consentito è %1$d secondi',
	'UI:FillAllMandatoryFields' => 'Per favore, compila tutti i campi obbligatori.',
	'UI:ValueMustBeSet' => 'Per favore, specifica un valore',
	'UI:ValueMustBeChanged' => 'Per favore, cambia il valore',
	'UI:ValueInvalidFormat' => 'Formato non valido',
	'UI:CSVImportConfirmTitle' => 'Conferma l\'operazione',
	'UI:CSVImportConfirmMessage' => 'Sei sicuro di volerlo fare?',
	'UI:CSVImportError_items' => 'Errori: %1$d',
	'UI:CSVImportCreated_items' => 'Creati: %1$d',
	'UI:CSVImportModified_items' => 'Modificati: %1$d',
	'UI:CSVImportUnchanged_items' => 'Immutati: %1$d',
	'UI:CSVImport:DateAndTimeFormats' => 'Formato data e ora',
	'UI:CSVImport:DefaultDateTimeFormat_Format_Example' => 'Formato predefinito: %1$s (es. %2$s)',
	'UI:CSVImport:CustomDateTimeFormat' => 'Formato personalizzato: %1$s',
	'UI:CSVImport:CustomDateTimeFormatTooltip' => 'Segnaposto disponibili:<table>
	<tr><td>Y</td><td>anno (4 cifre, es. 2016)</td></tr>
	<tr><td>y</td><td>anno (2 cifre, es. 16 per 2016)</td></tr>
	<tr><td>m</td><td>mese (2 cifre, es. 01..12)</td></tr>
	<tr><td>n</td><td>mese (1 o 2 cifre senza zero iniziale, es. 1..12)</td></tr>
	<tr><td>d</td><td>giorno (2 cifre, es. 01..31)</td></tr>
	<tr><td>j</td><td>giorno (1 o 2 cifre senza zero iniziale, es. 1..31)</td></tr>
	<tr><td>H</td><td>ora (24 ore, 2 cifre, es. 00..23)</td></tr>
	<tr><td>h</td><td>ora (12 ore, 2 cifre, es. 01..12)</td></tr>
	<tr><td>G</td><td>ora (24 ore, 1 o 2 cifre senza zero iniziale, es. 0..23)</td></tr>
	<tr><td>g</td><td>ora (12 ore, 1 o 2 cifre senza zero iniziale, es. 1..12)</td></tr>
	<tr><td>a</td><td>ora, am o pm (minuscolo)</td></tr>
	<tr><td>A</td><td>ora, AM o PM (maiuscolo)</td></tr>
	<tr><td>i</td><td>minuti (2 cifre, es. 00..59)</td></tr>
	<tr><td>s</td><td>secondi (2 cifre, es. 00..59)</td></tr>
	</table>',
	'UI:Button:Remove' => 'Rimuovi',
	'UI:AddAnExisting_Class' => 'Aggiungi oggetti di tipo %1$s...',
	'UI:SelectionOf_Class' => 'Selezione di oggetti di tipo %1$s',
	'UI:AboutBox' => 'Informazioni su '.ITOP_APPLICATION_SHORT.'...',
	'UI:About:Title' => 'Informazioni su '.ITOP_APPLICATION_SHORT, 'UI:About:DataModel' => 'Modello di dati',
	'UI:About:Support' => 'Informazioni di supporto',
	'UI:About:Licenses' => 'Licenze',
	'UI:About:InstallationOptions' => 'Opzioni di installazione',
	'UI:About:ManualExtensionSource' => 'Estensione',
	'UI:About:Extension_Version' => 'Versione: %1$s',
	'UI:About:RemoteExtensionSource' => 'Dati',
	'UI:DisconnectedDlgMessage' => 'Sei disconnesso. Devi identificarti di nuovo per continuare a utilizzare l\'applicazione.',
	'UI:DisconnectedDlgTitle' => 'Attenzione!',
	'UI:LoginAgain' => 'Effettua di nuovo il login',
	'UI:StayOnThePage' => 'Resta su questa pagina',
	'ExcelExporter:ExportMenu' => 'Esporta in Excel...',
	'ExcelExporter:ExportDialogTitle' => 'Esporta in Excel',
	'ExcelExporter:ExportButton' => 'Esporta',
	'ExcelExporter:DownloadButton' => 'Scarica %1$s',
	'ExcelExporter:RetrievingData' => 'Recupero dati...',
	'ExcelExporter:BuildingExcelFile' => 'Creazione del file Excel...',
	'ExcelExporter:Done' => 'Completato.',
	'ExcelExport:AutoDownload' => 'Inizia il download automaticamente una volta che l\'esportazione è pronta',
	'ExcelExport:PreparingExport' => 'Preparazione dell\'esportazione...',
	'ExcelExport:Statistics' => 'Statistiche',
	'portal:legacy_portal' => 'Portale per gli utenti finali',
	'portal:backoffice' => 'Interfaccia utente di '.ITOP_APPLICATION_SHORT.' Back-Office',
	'UI:CurrentObjectIsLockedBy_User' => 'L\'oggetto è bloccato in quanto è attualmente in fase di modifica da parte di %1$s.',
	'UI:CurrentObjectIsLockedBy_User_Explanation' => 'L\'oggetto è attualmente in fase di modifica da parte di %1$s. Le tue modifiche non possono essere inviate poiché verrebbero sovrascritte.',
	'UI:CurrentObjectIsSoftLockedBy_User' => 'L\'oggetto è attualmente in fase di modifica da parte di %1$s. Sarai in grado di inviare le tue modifiche una volta completate.',
	'UI:CurrentObjectLockExpired' => 'Il blocco per prevenire modifiche simultanee all\'oggetto è scaduto.',
	'UI:CurrentObjectLockExpired_Explanation' => 'Il blocco per prevenire modifiche simultanee all\'oggetto è scaduto. Non è più possibile inviare le modifiche poiché ora gli altri utenti sono autorizzati a modificare questo oggetto.',
	'UI:ConcurrentLockKilled' => 'Il blocco per prevenire modifiche simultanee all\'oggetto corrente è stato eliminato.',
	'UI:Menu:KillConcurrentLock' => 'Elimina il Blocco di Modifica Concorrente!',
	'UI:Menu:ExportPDF' => 'Esporta come PDF...',
	'UI:Menu:PrintableVersion' => 'Versione stampabile',
	'UI:BrowseInlineImages' => 'Sfoglia le immagini...',
	'UI:UploadInlineImageLegend' => 'Carica una nuova immagine',
	'UI:SelectInlineImageToUpload' => 'Seleziona l\'immagine da caricare',
	'UI:AvailableInlineImagesLegend' => 'Immagini disponibili',
	'UI:NoInlineImage' => 'Non ci sono immagini disponibili sul server. Utilizza il pulsante "Sfoglia" sopra per selezionare un\'immagine dal tuo computer e caricarla sul server.',
	'UI:ToggleFullScreen' => 'Attiva/Disattiva a schermo intero',
	'UI:Button:ResetImage' => 'Ripristina l\'immagine precedente',
	'UI:Button:RemoveImage' => 'Rimuovi l\'immagine',
	'UI:Button:UploadImage' => 'Carica un\'immagine dal disco',
	'UI:UploadNotSupportedInThisMode' => 'La modifica di immagini o file non è supportata in questa modalità.',
	'UI:Button:RemoveDocument' => 'Rimuovi il documento',
	'UI:Search:Toggle' => 'Riduci / Espandi',
	'UI:Search:AutoSubmit:DisabledHint' => 'L\'invio automatico è stato disabilitato per questa classe',
	'UI:Search:Obsolescence:DisabledHint' => 'In base alle tue preferenze, i dati obsoleti sono nascosti',
	'UI:Search:NoAutoSubmit:ExplainText' => 'Aggiungi alcuni criteri nella casella di ricerca o fai clic sul pulsante di ricerca per visualizzare gli oggetti.',
	'UI:Search:Criterion:MoreMenu:AddCriteria' => 'Aggiungi nuovi criteri',
	'UI:Search:AddCriteria:List:RecentlyUsed:Title' => 'Usati di recente',
	'UI:Search:AddCriteria:List:MostPopular:Title' => 'Più popolari',
	'UI:Search:AddCriteria:List:Others:Title' => 'Altri',
	'UI:Search:AddCriteria:List:RecentlyUsed:Placeholder' => 'Nessuno ancora.',
	'UI:Search:Criteria:Toggle' => 'Riduci / Espandi',
	'UI:Search:Criteria:Remove' => 'Rimuovi',
	'UI:Search:Criteria:Locked' => 'Bloccato',
	'UI:Search:Criteria:Title:Default:Any' => '%1$s: Qualsiasi',
	'UI:Search:Criteria:Title:Default:Empty' => '%1$s è vuoto',
	'UI:Search:Criteria:Title:Default:NotEmpty' => '%1$s non è vuoto',
	'UI:Search:Criteria:Title:Default:Equals' => '%1$s uguale a %2$s',
	'UI:Search:Criteria:Title:Default:Contains' => '%1$s contiene %2$s',
	'UI:Search:Criteria:Title:Default:StartsWith' => '%1$s inizia con %2$s',
	'UI:Search:Criteria:Title:Default:EndsWith' => '%1$s termina con %2$s',
	'UI:Search:Criteria:Title:Default:RegExp' => '%1$s corrisponde a %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThan' => '%1$s > %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThanOrEquals' => '%1$s >= %2$s',
	'UI:Search:Criteria:Title:Default:LessThan' => '%1$s < %2$s',
	'UI:Search:Criteria:Title:Default:LessThanOrEquals' => '%1$s <= %2$s',
	'UI:Search:Criteria:Title:Default:Different' => '%1$s ≠ %2$s',
	'UI:Search:Criteria:Title:Default:Between' => '%1$s tra [%2$s]',
	'UI:Search:Criteria:Title:Default:BetweenDates' => '%1$s [%2$s]',
	'UI:Search:Criteria:Title:Default:BetweenDates:All' => '%1$s: Qualsiasi',
	'UI:Search:Criteria:Title:Default:BetweenDates:From' => '%1$s da %2$s',
	'UI:Search:Criteria:Title:Default:BetweenDates:Until' => '%1$s fino al %2$s',
	'UI:Search:Criteria:Title:Default:Between:All' => '%1$s: Qualsiasi',
	'UI:Search:Criteria:Title:Default:Between:From' => '%1$s da %2$s',
	'UI:Search:Criteria:Title:Default:Between:Until' => '%1$s fino a %2$s',
	'UI:Search:Criteria:Title:DateTime:Between' => '%2$s <= %1$s <= %3$s',
	'UI:Search:Criteria:Title:Enum:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:Enum:In:Many' => '%1$s: %2$s e altri %3$s',
	'UI:Search:Criteria:Title:Enum:In:All' => '%1$s: Qualsiasi',
	'UI:Search:Criteria:Title:TagSet:Matches' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:ExternalKey:Empty' => '%1$s è definito',
	'UI:Search:Criteria:Title:ExternalKey:NotEmpty' => '%1$s non è definito',
	'UI:Search:Criteria:Title:ExternalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In:Many' => '%1$s: %2$s e altri %3$s',
	'UI:Search:Criteria:Title:ExternalKey:In:All' => '%1$s: Qualsiasi',
	'UI:Search:Criteria:Title:HierarchicalKey:Empty' => '%1$s è definito',
	'UI:Search:Criteria:Title:HierarchicalKey:NotEmpty' => '%1$s non è definito',
	'UI:Search:Criteria:Title:HierarchicalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In:Many' => '%1$s: %2$s e altri %3$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In:All' => '%1$s: Qualsiasi',
	'UI:Search:Criteria:Operator:Default:Empty' => 'È vuoto',
	'UI:Search:Criteria:Operator:Default:NotEmpty' => 'Non è vuoto',
	'UI:Search:Criteria:Operator:Default:Equals' => 'Uguale',
	'UI:Search:Criteria:Operator:Default:Between' => 'Tra',
	'UI:Search:Criteria:Operator:String:Contains' => 'Contiene',
	'UI:Search:Criteria:Operator:String:StartsWith' => 'Inizia con',
	'UI:Search:Criteria:Operator:String:EndsWith' => 'Termina con',
	'UI:Search:Criteria:Operator:String:RegExp' => 'Espressione regolare',
	'UI:Search:Criteria:Operator:Numeric:Equals' => 'Uguale',
	'UI:Search:Criteria:Operator:Numeric:GreaterThan' => 'Maggiore di',
	'UI:Search:Criteria:Operator:Numeric:GreaterThanOrEquals' => 'Maggiore o uguale a',
	'UI:Search:Criteria:Operator:Numeric:LessThan' => 'Minore di',
	'UI:Search:Criteria:Operator:Numeric:LessThanOrEquals' => 'Minore o uguale a',
	'UI:Search:Criteria:Operator:Numeric:Different' => 'Diverso',
	'UI:Search:Criteria:Operator:TagSet:Matches' => 'Corrisponde',
	'UI:Search:Value:Filter:Placeholder' => 'Filtra...',
	'UI:Search:Value:Search:Placeholder' => 'Cerca...',
	'UI:Search:Value:Autocomplete:StartTyping' => 'Inizia a digitare per valori possibili.',
	'UI:Search:Value:Autocomplete:Wait' => 'Attendere prego...',
	'UI:Search:Value:Autocomplete:NoResult' => 'Nessun risultato.',
	'UI:Search:Value:Toggler:CheckAllNone' => 'Seleziona tutti / nessuno',
	'UI:Search:Value:Toggler:CheckAllNoneFiltered' => 'Seleziona tutti / nessuno visibili',
	'UI:Search:Criteria:Numeric:From' => 'Da',
	'UI:Search:Criteria:Numeric:Until' => 'A',
	'UI:Search:Criteria:Numeric:PlaceholderFrom' => 'Qualsiasi',
	'UI:Search:Criteria:Numeric:PlaceholderUntil' => 'Qualsiasi',
	'UI:Search:Criteria:DateTime:From' => 'Da',
	'UI:Search:Criteria:DateTime:FromTime' => 'Da',
	'UI:Search:Criteria:DateTime:Until' => 'Fino a',
	'UI:Search:Criteria:DateTime:UntilTime' => 'Fino a',
	'UI:Search:Criteria:DateTime:PlaceholderFrom' => 'Qualsiasi data',
	'UI:Search:Criteria:DateTime:PlaceholderFromTime' => 'Qualsiasi data',
	'UI:Search:Criteria:DateTime:PlaceholderUntil' => 'Qualsiasi data',
	'UI:Search:Criteria:DateTime:PlaceholderUntilTime' => 'Qualsiasi data',
	'UI:Search:Criteria:HierarchicalKey:ChildrenIncluded:Hint' => 'Verranno inclusi i figli degli oggetti selezionati.',
	'UI:Search:Criteria:Raw:Filtered' => 'Filtrato',
	'UI:Search:Criteria:Raw:FilteredOn' => 'Filtrato su %1$s',
	'UI:StateChanged' => 'Stato cambiato'
));

//
// Expression to Natural language
//
Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Expression:Operator:AND' => ' E ',
	'Expression:Operator:OR' => ' O ',
	'Expression:Operator:=' => ': ',
	'Expression:Unit:Short:DAY' => 'g',
	'Expression:Unit:Short:WEEK' => 's',
	'Expression:Unit:Short:MONTH' => 'm',
	'Expression:Unit:Short:YEAR' => 'a',
	'Expression:Unit:Long:DAY' => 'giorno(i)',
	'Expression:Unit:Long:HOUR' => 'ora(e)',
	'Expression:Unit:Long:MINUTE' => 'minuto(i)',
	'Expression:Verb:NOW' => 'ora',
	'Expression:Verb:ISNULL' => ': non definito',
));

//
// iTop Newsroom menu
//
Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'UI:Newsroom:NoNewMessage' => 'Nessun nuovo messaggio',
	'UI:Newsroom:XNewMessage' => '%1$s nuovo/i messaggio/i',
	'UI:Newsroom:MarkAllAsRead' => 'Segna tutti come letti',
	'UI:Newsroom:ViewAllMessages' => 'Visualizza tutti i messaggi',
	'UI:Newsroom:Preferences' => 'Preferenze Newsroom',
	'UI:Newsroom:ConfigurationLink' => 'Configurazione',
	'UI:Newsroom:ResetCache' => 'Resetta la cache',
	'UI:Newsroom:ResetCache:Success:Message' => 'La cache della tua newsroom è stata resettata con successo',
	'UI:Newsroom:DisplayMessagesFor_Provider' => 'Mostra messaggi da %1$s',
	'UI:Newsroom:DisplayAtMost_X_Messages' => 'Mostra fino a %1$s messaggi nel menu %2$s.',
	'UI:Newsroom:Priority:1:Tooltip' => 'Critico',
	'UI:Newsroom:Priority:2:Tooltip' => 'Urgente',
	'UI:Newsroom:Priority:3:Tooltip' => 'Importante',
	'UI:Newsroom:Priority:4:Tooltip' => 'Normale',
));


Dict::Add('IT IT', 'Italian', 'Italiano', array(
	'Menu:DataSources' => 'Sorgente di sincronizzazione dei dati',
	'Menu:DataSources+' => '',
	'Menu:AuditCategories' => 'Categorie di Audit',
	'Menu:AuditCategories+' => '',
	'Menu:AuditCategories:Title' => 'Audit configuration',
	'Menu:RunQueriesMenu' => 'Esegui query',
	'Menu:RunQueriesMenu+' => '',
	'Menu:QueryMenu' => 'Rubbrica delle Query',
	'Menu:QueryMenu+' => 'Rubbrica delle Query',
	'Menu:UniversalSearchMenu' => 'Ricerca universale',
	'Menu:UniversalSearchMenu+' => '',
	'Menu:UserManagementMenu' => 'Gestione degli utenti',
	'Menu:UserManagementMenu+' => '',
	'Menu:ProfilesMenu' => 'Profili',
	'Menu:ProfilesMenu+' => '',
	'Menu:ProfilesMenu:Title' => 'Profili',
	'Menu:UserAccountsMenu' => 'Account utente',
	'Menu:UserAccountsMenu+' => '',
	'Menu:UserAccountsMenu:Title' => 'Account utente',
	'Menu:UserManagement' => 'Gestione utenti',
	'Menu:Queries' => 'Interrogazioni',
	'Menu:ConfigurationTools' => 'configurazione',
	'Menu:ConfigEditor' => 'General configuration~~',
	'Menu:ConfigEditor+' => 'Configuration File editor~~',
	'Menu:Integrations' => 'Integrations~~',
	'Menu:Integrations+' => '~~',

));
